package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.StringValue

import java.io.BufferedReader

class JavaStringValue(v: String, clazz: Class[_], val locationString: () => String) extends StringValue with JavaValue[String] {

  override def evaluate(implicit ctx: EvaluationContext): String = v

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    Some(JavaSchema(clazz))
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = v
}

object JavaStringValue {
  def apply(char: Char, loc: () => String): JavaStringValue = {
    new JavaStringValue(char.toString, char.getClass, loc)
  }

  def apply(bite: Byte, loc: () => String): JavaStringValue = {
    new JavaStringValue(bite.toString, bite.getClass, loc)
  }

  def apply(bite: java.lang.Byte, loc: () => String): JavaStringValue = {
    new JavaStringValue(bite.toString, bite.getClass, loc)
  }

  def apply(reader: java.io.Reader, loc: () => String): JavaStringValue = {
    val stringBuilder = new StringBuilder()
    try {
      val bufferedReader = new BufferedReader(reader)

      var line = bufferedReader.readLine()
      while (line != null) {
        stringBuilder.append(line).append("\n")
        line = bufferedReader.readLine()
      }
    } finally {
      reader.close()
    }
    new JavaStringValue(stringBuilder.toString(), reader.getClass, loc)
  }

  def apply(value: Any, loc: () => String): JavaStringValue = {
    new JavaStringValue(value.toString, value.getClass, loc)
  }

  def apply(string: String, loc: () => String): JavaStringValue = {
    new JavaStringValue(string, string.getClass, loc)
  }

  def apply(string: CharSequence, loc: () => String): JavaStringValue = {
    new JavaStringValue(string.toString, string.getClass, loc)
  }
}
