package org.mule.weave.v2.module.commons.java

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaHeavyValueCapable

object JavaValueHelper {
  /**
    * Check if the given value should consider as heavy value.
    *
    * @param value the value to evaluate.
    * @param ctx The evaluation context.
    * @return true when it should consider as heavy value
    */
  def isHeavyValue(value: Value[_])(implicit ctx: EvaluationContext): Boolean =
    value match {
      case jv: JavaHeavyValueCapable =>
        jv.isHeavyValue
      case _ =>
        false
    }
}
