package org.mule.weave.v2.module.commons.java.writer.entry

import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.JavaAdapter
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

import java.util

class MapPropertyEntry(override val location: LocationCapable, name: String, container: util.Map[String, Any], override val schemaOption: Option[Schema], valueComponent: Class[_], duplicatedKeyAsArray: Boolean = false)(implicit val converter: BaseJavaDataConverter) extends WriterEntry {

  override def entryType() = valueComponent

  def write(value: Any) {
    if (duplicatedKeyAsArray) {
      val oldValue = container.get(name)
      val newValue = if (oldValue == null) {
        value
      } else {
        toArray(oldValue, value)
      }
      container.put(name, newValue)
    } else {
      container.put(name, JavaAdapter.fromScalaToJava(value))
    }
  }

  private def toArray(oldValue: Any, value: Any): util.ArrayList[Any] = {
    oldValue match {
      case existingList: util.ArrayList[Any] =>
        existingList.add(value)
        existingList
      case _ =>
        val newList = new util.ArrayList[Any]()
        newList.add(oldValue)
        newList.add(value)
        newList
    }
  }

  override def resolveEntryValue(): Any = container

}