package org.mule.weave.v2.module.commons.java.writer.entry

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

class MapContainerEntry(override val location: LocationCapable, map: java.util.Map[String, Any], override val schemaOption: Option[Schema], valueComponent: Class[_], duplicatedKeysAsArray: Boolean)(implicit ctx: EvaluationContext, implicit val converter: BaseJavaDataConverter) extends WriterEntry with PropertyAwareEntry {

  override def write(value: Any): Unit = {}

  override def entryType(): Class[_] = map.getClass

  override def resolveEntryValue(): Any = map

  override def createPropertyEntry(location: LocationCapable, qname: QualifiedName, schema: Option[Schema]): WriterEntry = {
    new MapPropertyEntry(location, qname.name, map, schema, valueComponent, duplicatedKeysAsArray)
  }
}
