package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.core.io.SeekableStream
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.BinaryValue
import org.mule.weave.v2.model.values.math.Number

class ByteDataConverter extends DataConverter[Byte] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Byte] = {
    source match {
      case ch: Byte                  => Option(ch)
      case str: String               => if (str.nonEmpty) Option(str.getBytes().apply(0)) else None
      case number: Number            => Some(number.toByte)
      case ch: SeekableStream        => Some(BinaryValue.getBytesFromSeekableStream(ch, ctx.serviceManager.memoryService).apply(0))
      case ch: Array[java.lang.Byte] => Some(ch.apply(0))
      case ch: Array[Byte]           => Some(ch.apply(0))
      case _                         => None
    }

  }
}
