package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.math.Number

class JavaNumberValue(v: Number, val _underlying: Any, val locationString: () => String) extends NumberValue with JavaValue[Number] {

  override def evaluate(implicit ctx: EvaluationContext): Number = v

  override def underlying()(implicit ctx: EvaluationContext): Any = _underlying
}

object JavaNumberValue {
  implicit def apply(i: Int, loc: () => String): JavaNumberValue = {
    new JavaNumberValue(Number(i), i, loc)
  }

  implicit def apply(i: Int, underlying: Any, loc: () => String): JavaNumberValue = {
    new JavaNumberValue(Number(i), underlying, loc)
  }

  implicit def apply(l: Long, loc: () => String): JavaNumberValue = {
    new JavaNumberValue(Number(l), l, loc)
  }

  implicit def apply(l: Long, underlying: Any, loc: () => String): JavaNumberValue = {
    new JavaNumberValue(Number(l), underlying, loc)
  }

  implicit def apply(f: Float, loc: () => String): JavaValue[_] = {
    if (java.lang.Float.isNaN(f) || java.lang.Float.isInfinite(f)) {
      new JavaNaNValue(f, loc)
    } else {
      new JavaNumberValue(Number(f), f, loc)
    }
  }

  implicit def apply(d: Double, underlying: Any, loc: () => String): JavaValue[_] = {
    if (java.lang.Double.isNaN(d) || java.lang.Double.isInfinite(d)) {
      new JavaNaNValue(d, loc)
    } else {
      new JavaNumberValue(Number(d), underlying, loc)
    }
  }

  implicit def apply(d: Double, loc: () => String): JavaValue[_] = {
    if (java.lang.Double.isNaN(d) || java.lang.Double.isInfinite(d)) {
      new JavaNaNValue(d, loc)
    } else {
      new JavaNumberValue(Number(d), d, loc)
    }
  }

  implicit def apply(bd: java.math.BigDecimal, loc: () => String): JavaNumberValue = {
    new JavaNumberValue(Number(bd), bd, loc)
  }

  implicit def apply(bi: java.math.BigInteger, loc: () => String): JavaNumberValue = {
    new JavaNumberValue(Number(bi), bi, loc)
  }
}