package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.LocalDateValue

import java.time.LocalDate
import java.util.Calendar
import java.util.Date

trait JavaLocalDateValue extends LocalDateValue with JavaValue[LocalDate] {

}

object JavaLocalDateValue {
  def apply(value: LocalDate, locationString: () => String): JavaValue[LocalDate] = new JavaTimeLocalDateValue(value, locationString)

  def apply(sqlDate: java.sql.Date, loc: () => String): JavaValue[LocalDate] = new JavaSqlDateValue(sqlDate, loc)
}

class JavaSqlDateValue(sqlDate: java.sql.Date, val locationString: () => String) extends JavaLocalDateValue {

  lazy val value: T = {
    val date: Date = new Date(sqlDate.getTime)
    val instance: Calendar = Calendar.getInstance()
    instance.setTime(date)
    LocalDate.of(
      instance.get(Calendar.YEAR),
      instance.get(Calendar.MONTH) + 1,
      instance.get(Calendar.DAY_OF_MONTH))
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value

  override def underlying()(implicit ctx: EvaluationContext): Any = sqlDate
}

class JavaTimeLocalDateValue(value: LocalDate, val locationString: () => String) extends JavaLocalDateValue {
  override def underlying()(implicit ctx: EvaluationContext): Any = value

  override def evaluate(implicit ctx: EvaluationContext): T = value
}

