package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

trait DataConverter[T] {
  def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[T]

  def format(implicit arguments: Map[String, Any]): Option[String] = {
    val format: Option[Any] = arguments.get("format")
    if (format.isDefined) {
      Option(format.get.toString)
    } else {
      None
    }
  }

  def separator(implicit arguments: Map[String, Any]): Option[String] = {
    val separator: Option[Any] = arguments.get("separator")
    if (separator.isDefined) {
      Option(separator.get.toString)
    } else {
      None
    }
  }

  def encoding(implicit arguments: Map[String, Any]): Option[String] = {
    val encoding: Option[Any] = arguments.get("encoding")
    if (encoding.isDefined) {
      Option(encoding.get.toString)
    } else {
      None
    }
  }
}

object DataConverter {

  implicit object StringDataConverter$ extends StringDataConverter

  def to[T](value: Any, schema: Option[Schema])(implicit transformer: DataConverter[T], ctx: EvaluationContext): Option[T] = {
    try {
      transformer.convert(value, schema)
    } catch {
      case _: Exception => None
    }
  }

}
