package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.core.io.SeekableStream
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.BinaryValue
import org.mule.weave.v2.model.values.math.Number

class ByteArrayDataConverter extends DataConverter[Array[Byte]] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Array[Byte]] = {
    source match {
      case ch: Byte                  => Some(Array(ch))
      case ch: SeekableStream        => Some(BinaryValue.getBytesFromSeekableStream(ch, ctx.serviceManager.memoryService))
      case ch: Array[java.lang.Byte] => Some(ch.map(_.byteValue()))
      case ch: Array[Byte]           => Some(ch)
      case str: String               => Some(str.getBytes)
      case number: Number            => Some(Array(number.toByte))
      case _                         => None
    }
  }
}

class ByteWrapperArrayDataConverter extends DataConverter[Array[java.lang.Byte]] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Array[java.lang.Byte]] = {
    source match {
      case ch: Byte                  => Some(Array(ch))
      case ch: Array[java.lang.Byte] => Some(ch)
      case ch: SeekableStream        => Some(BinaryValue.getBytesFromSeekableStream(ch, ctx.serviceManager.memoryService).map(new java.lang.Byte(_)))
      case ch: Array[Byte]           => Some(ch.map(new java.lang.Byte(_)))
      case str: String               => convert(str.getBytes, schema)
      case number: Number            => Some(Array(number.toByte))
      case _                         => None
    }
  }
}