package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class BigDecimalDataConverter extends DataConverter[java.math.BigDecimal] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[java.math.BigDecimal] = {
    source match {
      case bigDecimal: java.math.BigDecimal => Some(bigDecimal)
      case _ => {
        val d: java.math.BigDecimal = source match {
          case l: Long                  => java.math.BigDecimal.valueOf(l)
          case i: Int                   => java.math.BigDecimal.valueOf(i.toLong)
          case d: Double                => java.math.BigDecimal.valueOf(d)
          case d: Float                 => java.math.BigDecimal.valueOf(d)
          case s: Short                 => java.math.BigDecimal.valueOf(s.toLong)
          case n: Number                => n.toBigDecimal.bigDecimal
          case bd: java.math.BigDecimal => bd
          case bi: java.math.BigInteger => new java.math.BigDecimal(bi)
          case str: String              => new java.math.BigDecimal(str)
          case _                        => null
        }
        Option(d)
      }
    }

  }
}
