package org.mule.weave.v2.module.commons.java.writer

import org.mule.weave.v2.module.writer.ConfigurableDuplicateKeyAsArray
import org.mule.weave.v2.module.writer.ConfigurableWriteAttributes

class JavaWriterSettings extends ConfigurableDuplicateKeyAsArray with ConfigurableWriteAttributes {}

object ReadOnlyDefaultJavaWriterSettings extends JavaWriterSettings {

  private var readOnly = false
  initSettings(settingsOptions())
  readOnly = true

  override def set(settingName: String, value: Any): Unit = {
    if (readOnly) {
      throw new RuntimeException("Trying to set a property in readOnly mode")
    } else {
      super.set(settingName, value)
    }
  }
}
