package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.TimeZoneValue

import java.time.ZoneId
import java.time.ZoneOffset
import java.util.TimeZone

class JavaTimeZoneOffsetValue(zoneOffset: ZoneOffset, val locationString: () => String) extends TimeZoneValue with JavaValue[ZoneId] {
  override def underlying()(implicit ctx: EvaluationContext): Any = zoneOffset

  override def evaluate(implicit ctx: EvaluationContext): T = zoneOffset
}

class JavaTimeZoneValue(timeZone: TimeZone, val locationString: () => String) extends TimeZoneValue with JavaValue[ZoneId] {

  lazy val value: T = timeZone.toZoneId

  override def evaluate(implicit ctx: EvaluationContext): T = value

  override def underlying()(implicit ctx: EvaluationContext): Any = timeZone

}

object JavaTimeZoneValue {
  def apply(timeZone: TimeZone, loc: () => String): JavaTimeZoneValue = {
    new JavaTimeZoneValue(timeZone, loc)
  }

  def apply(timeZone: ZoneOffset, locationString: () => String): JavaValue[ZoneId] = new JavaTimeZoneOffsetValue(timeZone, locationString)
}
