package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.structure.schema.SchemaProperty
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.JavaTypesHelper

class JavaSchema(val clazz: Class[_], additionalProperties: Seq[SchemaProperty] = Seq.empty) extends Schema {

  private lazy val className = JavaTypesHelper.getClassName(clazz)

  private lazy val props: Seq[SchemaProperty] = {
    val value = SchemaProperty(StringValue(Schema.CLASS_PROPERTY_NAME), StringValue(className))
    if (additionalProperties.nonEmpty) {
      Seq(value) ++ additionalProperties
    } else {
      Seq(value)
    }
  }

  override def valueOf(propertyName: String)(implicit ctx: EvaluationContext): Option[Value[Any]] = {
    propertyName match {
      case "class" => Some(StringValue(className))
      case _       => super.valueOf(propertyName)
    }
  }
  override def `class`(implicit ctx: EvaluationContext): Option[String] = {
    Some(className)
  }

  override def properties()(implicit ctx: EvaluationContext): Seq[SchemaProperty] = props
}

object JavaSchema {
  def apply(clazz: Class[_]): JavaSchema = new JavaSchema(clazz)

  def apply(clazz: Class[_], additionalProperties: Seq[SchemaProperty]): JavaSchema = new JavaSchema(clazz, additionalProperties)
}