package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.parser.location.InputLocation

class JavaLocation(path: String) extends InputLocation {

  override def name: String = path

  override def locationString: String = path

  def child(subPath: String): JavaLocation = {
    new JavaLocation(s"$path.$subPath")
  }

  def child(index: Int): JavaLocation = {
    new JavaLocation(s"$path[$index]")
  }
}

object JavaLocation {
  def apply(path: String): JavaLocation = new JavaLocation(path)

  def propertyAccess(expr: () => String, propertyName: String) = {
    () => s"${expr()}.$propertyName"
  }

  def indexAccess(expr: () => String, index: Int) = {
    () => s"${expr()}[$index]"
  }
}

