package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.BoundedArraySeq
import org.mule.weave.v2.model.structure.IteratorHelper
import org.mule.weave.v2.model.values.Value

import java.util

class JavaListArrayValue(list: util.Collection[_], val locationString: () => String, converter: JavaValueConverter)(implicit ctx: EvaluationContext) extends JavaArrayValue {

  private lazy val value = new JavaCollectionArraySeq(list, locationString)

  override def evaluate(implicit ctx: EvaluationContext): T = {
    value
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = list

  private class JavaCollectionArraySeq(entries: util.Collection[_], val locationString: () => String) extends BoundedArraySeq {

    override def toIterator(): Iterator[Value[_]] = {
      val v = entries.iterator()
      new Iterator[Value[_]] {
        override def hasNext: Boolean = v.hasNext

        override def next(): Value[_] = converter.convert(v.next(), locationString)
      }
    }

    override def toSeq(): Seq[Value[_]] = {
      toArray().toSeq
    }

    override def toArray(): Array[Value[_]] = {
      val result = new Array[Value[_]](entries.size())
      val iterator = toIterator()
      var i = 0
      while (iterator.hasNext) {
        val nextValue = iterator.next()
        result.update(i, nextValue)
        i = i + 1
      }
      result
    }

    override def apply(index: Long)(implicit ctx: EvaluationContext): Option[Value[_]] = {
      if (index >= 0 && index < size()) {
        entries match {
          case list: java.util.List[_] => {
            Some(converter.convert(list.get(index.toInt), locationString))
          }
          case _ => {
            IteratorHelper.apply(index, value = toIterator())
          }
        }
      } else {
        None
      }
    }

    override def size(): Long = entries.size()

    override def materialized(): Boolean = true
  }

}
