package org.mule.weave.v2.module.commons.java

import java.io.InputStream
import java.lang
import java.util.Calendar
import java.util.Date
import java.util.Optional
import java.util.OptionalDouble
import java.util.OptionalInt
import java.util.OptionalLong
import java.util.TimeZone
import java.util.UUID
import java.util.regex.Pattern
import javax.xml.datatype.XMLGregorianCalendar
import scala.util.Try

object JavaTypesHelper {
  def isArray(clazz: Class[_]): Boolean = {
    clazz.isArray
  }

  def isByteArray(clazz: Class[_]): Boolean = {
    clazz.isArray && isByte(clazz.getComponentType)
  }

  def isSmallByteArray(clazz: Class[_]): Boolean = {
    clazz.isArray && isSmallByte(clazz.getComponentType)
  }

  def isTimeZone(clazz: Class[_]): Boolean = {
    classOf[TimeZone].isAssignableFrom(clazz)
  }

  def isCharSequence(clazz: Class[_]): Boolean = {
    classOf[CharSequence].isAssignableFrom(clazz)
  }

  def enumValueOf[T <: Enum[T]](cls: Class[_], stringValue: String): Option[Enum[_]] = {
    Try(Enum.valueOf(cls.asInstanceOf[Class[T]], stringValue).asInstanceOf[Enum[_]]).toOption
  }

  def isChar(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Char]) || propertyType.equals(java.lang.Character.TYPE) || propertyType.equals(classOf[java.lang.Character])
  }

  def isByte(propertyType: Class[_]): Boolean = {
    isSmallByte(propertyType) || propertyType.equals(classOf[lang.Byte])
  }

  private def isSmallByte(propertyType: Class[_]) = {
    propertyType.equals(classOf[Byte]) || propertyType.equals(java.lang.Byte.TYPE)
  }

  def isBoolean(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Boolean]) || propertyType.equals(java.lang.Boolean.TYPE) || propertyType.equals(classOf[java.lang.Boolean])
  }

  def isLong(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Long]) || propertyType.equals(java.lang.Long.TYPE) || propertyType.equals(classOf[java.lang.Long])
  }

  def isNumber(clazz: Class[_]): Boolean = {
    classOf[java.lang.Number].equals(clazz)
  }

  def isClass(clazz: Class[_]): Boolean = {
    classOf[java.lang.Class[_]].isAssignableFrom(clazz)
  }

  def isShort(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Short]) || propertyType.equals(java.lang.Short.TYPE) || propertyType.equals(classOf[java.lang.Short])
  }

  def isInt(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Int]) || propertyType.equals(java.lang.Integer.TYPE) || propertyType.equals(classOf[java.lang.Integer])
  }

  def isDouble(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Double]) || propertyType.equals(java.lang.Double.TYPE) || propertyType.equals(classOf[java.lang.Double])
  }

  def isFloat(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Float]) || propertyType.equals(java.lang.Float.TYPE) || propertyType.equals(classOf[java.lang.Float])
  }

  def isCalendar(propertyType: Class[_]): Boolean = {
    classOf[Calendar].isAssignableFrom(propertyType)
  }

  def isOptional(propertyType: Class[_]): Boolean = {
    classOf[Optional[_]].isAssignableFrom(propertyType)
  }

  def isOptionalInt(propertyType: Class[_]): Boolean = {
    classOf[OptionalInt].isAssignableFrom(propertyType)
  }

  def isOptionalLong(propertyType: Class[_]): Boolean = {
    classOf[OptionalLong].isAssignableFrom(propertyType)
  }

  def isOptionalDouble(propertyType: Class[_]): Boolean = {
    classOf[OptionalDouble].isAssignableFrom(propertyType)
  }

  def isXmlCalendar(propertyType: Class[_]): Boolean = {
    classOf[XMLGregorianCalendar].isAssignableFrom(propertyType)
  }

  def isInputStream(propertyType: Class[_]): Boolean = {
    classOf[InputStream].isAssignableFrom(propertyType)
  }

  def isDate(propertyType: Class[_]): Boolean = {
    propertyType.equals(classOf[Date])
  }

  def isEnum(propertyType: Class[_]): Boolean = {
    propertyType.isEnum
  }

  def isSqlDate(propertyType: Class[_]): Boolean = {
    classOf[java.sql.Date].isAssignableFrom(propertyType)
  }

  def isLocalTime(clazz: Class[_]): Boolean = {
    classOf[java.time.LocalTime].isAssignableFrom(clazz)
  }

  def isFunctionValue(clazz: Class[_]): Boolean = {
    classOf[java.util.function.Function[_, _]].isAssignableFrom(clazz)
  }

  def isLocalDateTime(clazz: Class[_]): Boolean = {
    classOf[java.time.LocalDateTime].isAssignableFrom(clazz)
  }

  def isLocalDate(clazz: Class[_]): Boolean = {
    classOf[java.time.LocalDate].isAssignableFrom(clazz)
  }

  def isZonedDateTime(clazz: Class[_]): Boolean = {
    classOf[java.time.ZonedDateTime].isAssignableFrom(clazz)
  }

  def isOffsetTime(clazz: Class[_]): Boolean = {
    classOf[java.time.OffsetTime].isAssignableFrom(clazz)
  }

  def isZoneId(clazz: Class[_]): Boolean = {
    classOf[java.time.ZoneId].isAssignableFrom(clazz)
  }

  def isString(propertyType: Class[_]): Boolean = {
    classOf[java.lang.String].isAssignableFrom(propertyType)
  }

  def isSqlTime(propertyType: Class[_]): Boolean = {
    classOf[java.sql.Time].isAssignableFrom(propertyType)
  }

  def isSqlTimestamp(propertyType: Class[_]): Boolean = {
    classOf[java.sql.Timestamp].isAssignableFrom(propertyType)
  }

  def isBigDecimal(propertyType: Class[_]): Boolean = {
    classOf[java.math.BigDecimal].isAssignableFrom(propertyType)
  }

  def isUUID(propertyType: Class[_]): Boolean = {
    classOf[UUID].isAssignableFrom(propertyType)
  }

  def isBigInteger(propertyType: Class[_]): Boolean = {
    classOf[java.math.BigInteger].isAssignableFrom(propertyType)
  }

  def isIterableType(clazz: Class[_]): Boolean = {
    classOf[java.lang.Iterable[_]].isAssignableFrom(clazz)
  }

  def isIteratorType(clazz: Class[_]): Boolean = {
    classOf[java.util.Iterator[_]].isAssignableFrom(clazz)
  }

  def isReader(clazz: Class[_]): Boolean = {
    classOf[java.io.Reader].isAssignableFrom(clazz)
  }

  def isInstant(clazz: Class[_]): Boolean = {
    classOf[java.time.Instant].isAssignableFrom(clazz)
  }

  def isMap(clazz: Class[_]): Boolean = {
    classOf[java.util.Map[_, _]].isAssignableFrom(clazz)
  }

  def isByteBuffer(clazz: Class[_]): Boolean = {
    classOf[java.nio.ByteBuffer].isAssignableFrom(clazz)
  }

  def isClob(clazz: Class[_]): Boolean = {
    classOf[java.sql.Clob].isAssignableFrom(clazz)
  }

  def isAtomicInteger(clazz: Class[_]): Boolean = {
    classOf[java.util.concurrent.atomic.AtomicInteger].isAssignableFrom(clazz)
  }

  def isAtomicLong(clazz: Class[_]): Boolean = {
    classOf[java.util.concurrent.atomic.AtomicLong].isAssignableFrom(clazz)
  }

  def isAtomicBoolean(clazz: Class[_]): Boolean = {
    classOf[java.util.concurrent.atomic.AtomicBoolean].isAssignableFrom(clazz)
  }

  def isBlob(clazz: Class[_]): Boolean = {
    classOf[java.sql.Blob].isAssignableFrom(clazz)
  }

  def isFile(clazz: Class[_]): Boolean = {
    classOf[java.io.File].isAssignableFrom(clazz)
  }

  def isSQLException(clazz: Class[_]): Boolean = {
    classOf[java.sql.SQLException].isAssignableFrom(clazz)
  }

  def isVoid(clazz: Class[_]): Boolean = {
    clazz.equals(classOf[Void]) || clazz.equals(java.lang.Void.TYPE) || clazz.equals(classOf[java.lang.Void])
  }

  def getClassName(clazz: Class[_]): String = {
    if (clazz.isArray) {
      try {
        var cl = clazz
        var dimensions = 0
        while (cl.isArray) {
          dimensions += 1
          cl = cl.getComponentType
        }
        val sb = new StringBuilder
        sb.append(getFriendlyName(cl))
        var i = 0
        while (i < dimensions) {
          sb.append("[]")
          i += 1
        }
        return sb.toString
      } catch {
        case e: Throwable =>
      }
    }
    getFriendlyName(clazz)
  }

  val short_name: String = "short"
  val int_name: String = "int"
  val long_name: String = "long"
  val float_name: String = "float"
  val double_name: String = "double"
  val byte_name: String = "byte"
  val char_name: String = "char"
  val boolean_name: String = "boolean"

  val short_class_name = java.lang.Short.TYPE.getName
  val integer_class_name = java.lang.Integer.TYPE.getName
  val long_class_name = java.lang.Long.TYPE.getName
  val float_class_name = java.lang.Float.TYPE.getName
  val double_class_name = java.lang.Double.TYPE.getName
  val byte_class_name = java.lang.Byte.TYPE.getName
  val char_class_name = java.lang.Character.TYPE.getName
  val boolean_class_name = java.lang.Boolean.TYPE.getName

  val reg: Pattern = Pattern.compile("\\s")

  private def getFriendlyName(cl: Class[_]) = {
    cl.getName match {
      case JavaTypesHelper.short_class_name   => short_name
      case JavaTypesHelper.integer_class_name => int_name
      case JavaTypesHelper.long_class_name    => long_name
      case JavaTypesHelper.float_class_name   => float_name
      case JavaTypesHelper.double_class_name  => double_name
      case JavaTypesHelper.byte_class_name    => byte_name
      case JavaTypesHelper.char_class_name    => char_name
      case JavaTypesHelper.boolean_class_name => boolean_name
      case _                                  => cl.getName
    }
  }
}
