package org.mule.weave.v2.dwb.api;

import java.io.InputStream;
import java.util.Map;

/**
 * This is a way to contribute processors to the dwb module for dynamic parsing of data.
 * This offloading will be triggered when binary values have the 'processor' schema property specifying the class.
 * The class needs to be visible in the classloader where the DW engine is running.
 */
public interface WeaveProcessor {

    /**
     * @param blob The data that will be parsed
     * @param key The key that's being accessed
     * @param schemaProperties These properties, which should contain the schemaPath and the object access path.
     * @return The resulting Java object or null is the key was not present
     */
    Object get(InputStream blob, String key, Map<String, IWeaveValue<?>> schemaProperties);
}