/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.mule.weave.maven.plugin.WeaveDocsMojo;
import org.mule.weave.maven.plugin.exchange.client.ExchangeClient;
import org.mule.weave.maven.plugin.exchange.client.MavenExchangeClientLogger;

@Mojo(name="deploy-docs", defaultPhase=LifecyclePhase.DEPLOY)
@Execute(goal="deploy-docs")
public class WeaveDeployDocsMojo
extends WeaveDocsMojo {
    private static final Pattern exchangeAnypointDomain = Pattern.compile("https://maven\\.(?<baseUri>.*anypoint\\.mulesoft\\.com)");
    private static final String MARKDOWN_FOLDER = "exchange_markdown";
    @Component
    protected SettingsDecrypter decrypter;

    @Override
    public void doExecute() {
        DeploymentRepository repository;
        if (Boolean.getBoolean("skipDeployDocs")) {
            this.getLog().warn((CharSequence)"Skipping Deploy of the WeaveDocs.");
            return;
        }
        try {
            repository = this.getDeploymentRepository();
        }
        catch (MojoFailureException e) {
            this.getLog().warn((CharSequence)String.format("Unable to get deployment repository: %s", e.getMessage()));
            return;
        }
        String url = repository.getUrl();
        Matcher matcher = exchangeAnypointDomain.matcher(url);
        Optional<File> maybeFavicon = Optional.ofNullable(this.config.getFavicon());
        if (matcher.find()) {
            String anypointUrl = "https://" + matcher.group("baseUri");
            Settings settings = this.loadDefaultUserSettings();
            if (settings != null) {
                Server server = settings.getServer(repository.getId());
                if (server != null) {
                    File exchangeOutputDoc = new File(this.config.getOutput(), MARKDOWN_FOLDER);
                    if (exchangeOutputDoc.exists()) {
                        Server decryptedServer = this.decrypt(server);
                        String username = decryptedServer.getUsername();
                        String password = decryptedServer.getPassword();
                        this.getLog().info((CharSequence)String.format("Deploying: `%s` to : `%s`", exchangeOutputDoc.getAbsolutePath(), anypointUrl));
                        ExchangeClient client = new ExchangeClient.Builder().withBaseAnypointUrl(anypointUrl).withUsername(username).withPassword(password).withLogger(new MavenExchangeClientLogger(this.getLog())).build();
                        client.uploadPortalPages(exchangeOutputDoc, this.project, maybeFavicon);
                        this.getLog().info((CharSequence)String.format("Deployed successful to: `%s`", anypointUrl));
                    } else {
                        this.getLog().warn((CharSequence)String.format("Ignoring deploy docs. Docs folder: %s was not found", exchangeOutputDoc.getAbsolutePath()));
                    }
                } else {
                    this.getLog().warn((CharSequence)"Ignoring deploy docs as server was not found");
                }
            }
        } else {
            this.getLog().warn((CharSequence)String.format("Unable to find anypoint url from: %s", url));
        }
    }

    private Settings loadDefaultUserSettings() {
        return this.session.getSettings();
    }

    private Server decrypt(Server server) {
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult decryptedResult = this.decrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        return decryptedResult.getServer();
    }
}

