/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.ValidationPhase;
import org.mule.weave.v2.inspector.Inspector;
import org.mule.weave.v2.inspector.NoInspector$;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ModuleLoader$;
import org.mule.weave.v2.parser.phase.ModuleLoaderManager;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager$;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.ChainedWeaveResourceResolver;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.versioncheck.SVersion;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, executionStrategy="always")
@Execute(goal="compile")
public class WeaveCompileMojo
extends AbstractWeaveMojo {
    private static final String DW_EXTENSION = "dwl";
    @Parameter(defaultValue="PARSING", required=false, readonly=false)
    protected ValidationPhase mappingValidation = ValidationPhase.PARSING;
    @Parameter(defaultValue="FULL", required=false, readonly=false)
    protected ValidationPhase modulesValidation = ValidationPhase.PARSING;
    @Parameter(name="implicitInputs")
    protected List<String> implicitInputs = new ArrayList<String>();
    @Parameter(name="languageLevel")
    protected String languageLevel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)String.format("Start Compiling DataWeave: `%s`", this.project.getName()));
        List<String> strings = super.compileClasspathElements();
        URL[] urls = (URL[])strings.stream().map(s -> {
            try {
                return new File((String)s).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader urlClassLoader = null;
        try {
            urlClassLoader = new URLClassLoader(urls, null);
            ChainedWeaveResourceResolver weaveResourceResolver = new ChainedWeaveResourceResolver((Seq)Seq$.MODULE$.newBuilder().$plus$eq((Object)new ClassLoaderResourceResolver(urlClassLoader)).$plus$eq((Object)new FolderResourceResolver(this.sourceFolder)).result());
            Seq loaders = (Seq)Seq$.MODULE$.newBuilder().$plus$eq((Object)ModuleLoader$.MODULE$.apply((WeaveResourceResolver)weaveResourceResolver)).result();
            ModuleParsingPhasesManager moduleParsingPhasesManager = ModuleParsingPhasesManager$.MODULE$.apply(ModuleLoaderManager.apply((Seq)loaders));
            int numberOfError = this.validate(this.sourceFolder, "", moduleParsingPhasesManager);
            if (numberOfError > 0) {
                throw new MojoFailureException(String.format("Compilation failure %s errors found.", numberOfError));
            }
        }
        finally {
            if (urlClassLoader != null) {
                try {
                    urlClassLoader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getLog().info((CharSequence)String.format("DataWeave `%s` successfully compiled", this.project.getName()));
    }

    private int validate(File sourceDir, String name, ModuleParsingPhasesManager moduleParsingPhasesManager) {
        File[] child;
        int errors = 0;
        for (File file : child = Optional.ofNullable(sourceDir.listFiles()).orElse(new File[0])) {
            if (this.isDWFile(file)) {
                this.getLog().debug((CharSequence)String.format("Compiling %s", file.getAbsolutePath()));
                String basename = FileUtils.basename((String)file.getName());
                errors += this.parse(NameIdentifier.apply((String)this.nameIdentifier(name, basename), (Option)Option.empty()), file, moduleParsingPhasesManager);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.validate(file, this.nameIdentifier(name, file.getName()), moduleParsingPhasesManager);
        }
        return errors;
    }

    private boolean isDWFile(File file) {
        return Optional.ofNullable(file).map(f -> DW_EXTENSION.equals(FileUtils.extension((String)f.getName()))).orElse(false);
    }

    private String nameIdentifier(String name, String moduleName) {
        if (name.isEmpty()) {
            return moduleName;
        }
        return name + NameIdentifier.SEPARATOR() + moduleName;
    }

    private int parse(NameIdentifier identifier, File file, ModuleParsingPhasesManager moduleParsingPhasesManager) {
        DocumentParser documentParser = new DocumentParser(15, (Inspector)NoInspector$.MODULE$);
        ParsingContext parsingContext = ParsingContextFactory.createParsingContext((NameIdentifier)identifier, (ModuleParsingPhasesManager)moduleParsingPhasesManager);
        for (String implicitInput : this.implicitInputs) {
            parsingContext.addImplicitInput(implicitInput, Option.empty());
        }
        if (this.languageLevel != null) {
            Option sVersionOption = SVersion.fromString((String)this.languageLevel);
            parsingContext.languageLevel_$eq(sVersionOption);
        }
        WeaveResource input = WeaveResourceFactory.fromFile((File)file);
        MessageCollector messages = this.compile(documentParser, input, parsingContext);
        Iterator errors = messages.errorMessages().toIterator();
        while (errors.hasNext()) {
            Tuple2 next = (Tuple2)errors.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            try {
                this.getLog().error((CharSequence)String.format("%s: [%s, %s]\n%s at %s", file.getCanonicalPath(), weaveLocation.startPosition().line(), weaveLocation.startPosition().column(), ((Message)next._2).message(), weaveLocation.locationString()));
            }
            catch (IOException iOException) {}
        }
        Iterator warnings = messages.warningMessages().toIterator();
        while (warnings.hasNext()) {
            Tuple2 next = (Tuple2)warnings.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            try {
                this.getLog().warn((CharSequence)String.format("%s: [%s, %s]\n%s at %s", file.getCanonicalPath(), weaveLocation.startPosition().line(), weaveLocation.startPosition().column(), ((Message)next._2).message(), weaveLocation.locationString()));
            }
            catch (IOException iOException) {}
        }
        return messages.errorMessages().length();
    }

    private MessageCollector compile(DocumentParser documentParser, WeaveResource input, ParsingContext parsingContext) {
        MessageCollector messages;
        PhaseResult parseResult = documentParser.parse(input, parsingContext);
        if (parseResult.hasResult()) {
            ParsingResult result = (ParsingResult)parseResult.getResult();
            if (result.astNode() instanceof ModuleNode) {
                if (this.modulesValidation == ValidationPhase.FULL) {
                    PhaseResult typeCheckingResultPhaseResult = documentParser.runAllPhases(input, parsingContext);
                    messages = typeCheckingResultPhaseResult.messages();
                } else {
                    messages = parseResult.messages();
                }
            } else if (this.mappingValidation == ValidationPhase.FULL) {
                PhaseResult typeCheckingResultPhaseResult = documentParser.runAllPhases(input, parsingContext);
                messages = typeCheckingResultPhaseResult.messages();
            } else {
                messages = parseResult.messages();
            }
        } else {
            messages = parseResult.messages();
        }
        return messages;
    }

    private static class FolderResourceResolver
    implements WeaveResourceResolver {
        private final File sourceFolder;

        public FolderResourceResolver(File sourceFolder) {
            this.sourceFolder = sourceFolder;
        }

        public Option<WeaveResource> resolve(NameIdentifier name) {
            String weaveFilePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
            return this.resolvePath(weaveFilePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Option<WeaveResource> resolvePath(String path) {
            String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
            File resource = new File(this.sourceFolder, weaveFilePath);
            if (resource.exists()) {
                FileInputStream input = null;
                try {
                    input = new FileInputStream(resource);
                    String content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                    Option option = Option.apply((Object)WeaveResource.apply((String)resource.toURI().toURL().toExternalForm(), (String)content));
                    return option;
                }
                catch (IOException e) {
                    Option option = Option.empty();
                    return option;
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return Option.empty();
        }

        public Seq<WeaveResource> resolveAll(NameIdentifier name) {
            return this.resolve(name).toList();
        }
    }

    private static class ClassLoaderResourceResolver
    implements WeaveResourceResolver {
        private final URLClassLoader urlClassLoader;

        public ClassLoaderResourceResolver(URLClassLoader urlClassLoader) {
            this.urlClassLoader = urlClassLoader;
        }

        public Option<WeaveResource> resolve(NameIdentifier name) {
            String weaveFilePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
            return this.resolvePath(weaveFilePath);
        }

        public Option<WeaveResource> resolvePath(String path) {
            String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
            URL resource = this.urlClassLoader.getResource(weaveFilePath);
            if (resource != null) {
                try {
                    String content = IOUtils.toString((InputStream)resource.openStream(), (Charset)StandardCharsets.UTF_8);
                    return Option.apply((Object)WeaveResource.apply((String)resource.toExternalForm(), (String)content));
                }
                catch (IOException e) {
                    return Option.empty();
                }
            }
            return Option.empty();
        }

        public Seq<WeaveResource> resolveAll(NameIdentifier name) {
            return this.resolve(name).toList();
        }
    }
}

