/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin.exchange.client;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;
import org.mule.weave.maven.plugin.client.RestClient;
import org.mule.weave.maven.plugin.exchange.client.ExchangeClientLogger;
import org.mule.weave.maven.plugin.exchange.client.MavenExchangeClientLogger;
import org.mule.weave.maven.plugin.exchange.client.model.AssetIdBody;
import org.mule.weave.maven.plugin.exchange.client.model.AuthorizationResponse;
import org.mule.weave.maven.plugin.exchange.client.model.Credentials;

public class ExchangeClient
extends RestClient {
    public static final String PROD_ENV = "https://anypoint.mulesoft.com";
    private static final String LOGIN = "/accounts/login";
    private static final String EXCHANGE_URL = "/exchange/api/v2";
    private static final String ASSET_URL = "/exchange/api/v2/assets/%s/%s";
    private static final String PORTAL_URL = "/exchange/api/v2/assets/%s/%s/%s/portal";
    private static final String DRAFT_PAGES_URL = "/exchange/api/v2/assets/%s/%s/%s/portal/draft/pages/%s";
    private static final String ICON_URL = "/exchange/api/v2/assets/%s/%s/icon";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final List<String> ICON_VALID_EXTENSIONS = Arrays.asList("jpg", "png", "svg");
    private static final String MAPPINGS_FILE_NAME = "Mappings.md";
    private static final String TEXT_MARKDOWN = "text/markdown";
    private static final String IMAGE_PNG = "image/png";
    private static final String EXCHANGE_INVALID_CHARS = "[\\@|\\*|\\/|\\\\|\\/|\\_|\\+]";
    private static final Pattern EXCHANGE_INVALID_CHARS_PATTERN = Pattern.compile("[\\@|\\*|\\/|\\\\|\\/|\\_|\\+]");
    private final String baseAnypointUrl;
    private final String username;
    private final String password;
    private final ExchangeClientLogger logger;
    private String bearerToken;

    public ExchangeClient(String baseAnypointUrl, String username, String password, ExchangeClientLogger logger) {
        super(true);
        this.baseAnypointUrl = baseAnypointUrl;
        this.username = username;
        this.password = password;
        this.logger = logger;
    }

    public String getBearerToken() {
        if (StringUtils.isBlank((CharSequence)this.bearerToken)) {
            Credentials credentials = new Credentials();
            credentials.setUsername(this.username);
            credentials.setPassword(this.password);
            AuthorizationResponse response = this.post(this.baseAnypointUrl, LOGIN, credentials, AuthorizationResponse.class);
            this.bearerToken = response.getAccessToken();
        }
        return this.bearerToken;
    }

    public void uploadPortalPages(File docsFolder, MavenProject project, Optional<File> maybeFavicon) {
        this.logger.info("Publishing portal pages ...");
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        this.uploadDrafts(docsFolder, groupId, artifactId, version);
        this.updateAsset(groupId, artifactId, project.getName(), project.getDescription());
        this.updateFavicon(groupId, artifactId, maybeFavicon);
        this.publishPortal(groupId, artifactId, version);
        this.logger.info("Published portal pages successfully.");
    }

    public void publishPortal(String groupId, String artifactId, String version) {
        try {
            String path = String.format(PORTAL_URL, this.encodeUtf8(groupId), this.encodeUtf8(artifactId), this.encodeUtf8(version));
            this.patch(this.baseAnypointUrl, path, this::addAuthorizationHeader);
        }
        catch (Exception e) {
            this.logger.error("An error has occurred publishing portal.", e);
            throw new RuntimeException(e);
        }
    }

    private void addAuthorizationHeader(Invocation.Builder builder) {
        builder.header(AUTHORIZATION_HEADER, (Object)("bearer " + this.getBearerToken()));
    }

    public void uploadDrafts(File docsFolder, String groupId, String artifactId, String version) {
        this.logger.info("Publishing drafts pages from `" + docsFolder.getName() + "`...");
        File[] files = Optional.ofNullable(docsFolder.listFiles()).orElse(new File[0]);
        List<File> sortedFiles = Arrays.stream(files).filter(file -> !MAPPINGS_FILE_NAME.equals(file.getName())).sorted().collect(Collectors.toList());
        Optional<File> maybeMappings = Arrays.stream(files).filter(file -> MAPPINGS_FILE_NAME.equals(file.getName())).findFirst();
        maybeMappings.ifPresent(sortedFiles::add);
        boolean fileNamesContainSpecialChars = sortedFiles.stream().anyMatch(file -> {
            Matcher matcher = EXCHANGE_INVALID_CHARS_PATTERN.matcher(file.getName());
            return matcher.find();
        });
        if (fileNamesContainSpecialChars && !sortedFiles.isEmpty()) {
            this.logger.error("File names cannot contain these characters: @ * + / _ \\\\");
            throw new RuntimeException("File names cannot contain these characters: @ * + / _ \\\\");
        }
        sortedFiles.forEach(file -> {
            if (file.isDirectory()) {
                this.uploadDrafts((File)file, groupId, artifactId, version);
            } else if ("md".equals(FilenameUtils.getExtension((String)file.getName()))) {
                String pagePath = FilenameUtils.getBaseName((String)file.getName());
                this.logger.info("Publishing draft page `" + pagePath + "`....");
                try {
                    Path filePath = Paths.get(file.getAbsolutePath(), new String[0]);
                    byte[] bytes = Files.readAllBytes(filePath);
                    String content = new String(bytes, StandardCharsets.UTF_8);
                    String path = String.format(DRAFT_PAGES_URL, groupId, artifactId, version, pagePath);
                    this.put(this.baseAnypointUrl, path, Entity.entity((Object)content, (String)TEXT_MARKDOWN), this::addAuthorizationHeader);
                    this.logger.info("Draft page `" + pagePath + "` published successfully.");
                }
                catch (Exception e) {
                    this.logger.error(String.format("Error while publishing draft page `%s`.", pagePath), e);
                    throw new RuntimeException(e);
                }
            }
        });
        this.logger.info("Draft pages from `" + docsFolder.getName() + "` published successfully.");
    }

    public void updateAsset(String groupId, String artifactId, String name, String description) {
        this.logger.info("Updating asset ...");
        if (StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)description)) {
            try {
                AssetIdBody body = new AssetIdBody();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    body.setName(name);
                }
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    body.setDescription(description);
                }
                String path = String.format(ASSET_URL, this.encodeUtf8(groupId), this.encodeUtf8(artifactId));
                this.patch(this.baseAnypointUrl, path, body, this::addAuthorizationHeader);
                this.logger.info("Asset updated successfully.");
            }
            catch (Exception e) {
                this.logger.error("Error while updating the asset.", e);
                throw new RuntimeException(e);
            }
        } else {
            this.logger.warn("Project name and description are not defined in the project's pom.xml. Name and description update will not be executed.");
        }
    }

    public void updateFavicon(String groupId, String artifactId, Optional<File> maybeFavicon) {
        this.logger.info("Updating icon ...");
        if (maybeFavicon.isPresent()) {
            File favicon = maybeFavicon.get();
            if (favicon.exists()) {
                String iconExtension = FilenameUtils.getExtension((String)favicon.getName());
                if (ICON_VALID_EXTENSIONS.contains(iconExtension)) {
                    try {
                        Path faviconPath = Paths.get(favicon.getAbsolutePath(), new String[0]);
                        byte[] bytes = Files.readAllBytes(faviconPath);
                        String path = String.format(ICON_URL, this.encodeUtf8(groupId), this.encodeUtf8(artifactId));
                        this.put(this.baseAnypointUrl, path, Entity.entity((Object)bytes, (String)IMAGE_PNG), this::addAuthorizationHeader);
                        this.logger.info("Icon updated successfully.");
                    }
                    catch (Exception e) {
                        this.logger.error("An error has occurred attempting to update the asset's icon.", e);
                        throw new RuntimeException(e);
                    }
                } else {
                    this.logger.warn(String.format("Invalid icon extension: extension: %s, valid: %s. Icon update will not be executed.", iconExtension, String.join((CharSequence)",", ICON_VALID_EXTENSIONS)));
                }
            } else {
                this.logger.warn("Invalid icon file configured. Icon update will not be executed.");
            }
        } else {
            this.logger.warn("Property faviconPath was not defined in the project's pom.xml. Icon update will not be executed.");
        }
    }

    public static class Builder {
        private String baseAnypointUrl;
        private String username;
        private String password;
        private MavenExchangeClientLogger logger;

        public Builder withBaseAnypointUrl(String baseAnypointUrl) {
            this.baseAnypointUrl = baseAnypointUrl;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withLogger(MavenExchangeClientLogger logger) {
            this.logger = logger;
            return this;
        }

        public ExchangeClient build() {
            if (StringUtils.isBlank((CharSequence)this.baseAnypointUrl)) {
                this.baseAnypointUrl = ExchangeClient.PROD_ENV;
            }
            return new ExchangeClient(this.baseAnypointUrl, this.username, this.password, this.logger);
        }
    }
}

