/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.maven.plugin.MojoUtils;
import org.mule.weave.maven.plugin.WeaveTestCommandlineExecutor;
import org.mule.weave.maven.plugin.WeaveTestMojoConfig;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(goal="test")
public class WeaveTestMojo
extends AbstractWeaveMojo {
    @Parameter(name="tests")
    protected WeaveTestMojoConfig config;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty("skipTests") != null) {
            this.getLog().warn((CharSequence)"Skipping Weave Tests.");
            return;
        }
        try {
            this.init();
            ArrayList dwITArgs = new ArrayList();
            String classpath = this.buildClassPathEnvironment();
            String[] args = MojoUtils.concat(dwITArgs, this.testsDirectories(), this.reports(), this.coverage(), this.aggregators());
            WeaveTestCommandlineExecutor executor = new WeaveTestCommandlineExecutor(this.project, this.getLog(), classpath, args, this.config);
            boolean success = executor.execute();
            if (!success) {
                throw new MojoFailureException("Tests Failed");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private void init() throws IOException {
        if (this.config == null) {
            this.config = new WeaveTestMojoConfig(this.getOutputFolder());
        }
        if (this.config.getOutput() == null) {
            this.config.setOutput(this.getOutputFolder());
        }
        if (this.dwTestFolder.getCanonicalFile().exists()) {
            if (this.config.getRunnerSystemProperties() == null) {
                this.config.setRunnerSystemProperties(new HashMap<String, String>());
            }
            this.config.getRunnerSystemProperties().put("dwtestDir", this.dwTestFolder.getCanonicalPath());
            this.config.getRunnerSystemProperties().put("dwtestResources", this.dwTestResources.getCanonicalPath());
        }
    }

    private File getOutputFolder() {
        return new File(this.project.getBuild().getDirectory() + File.separator + "data-weave-test-reports");
    }

    private String buildClassPathEnvironment() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String e : this.testClasspathElements()) {
            if (first) {
                first = false;
            } else {
                buffer.append(File.pathSeparator);
            }
            buffer.append(e);
        }
        return buffer.toString();
    }

    private List<String> testClasspathElements() {
        try {
            return this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Dependency resolution should be test-scoped.", e);
        }
    }

    private List<String> testsDirectories() throws IOException {
        return MojoUtils.compoundArg("-R", this.dwTestFolder.getCanonicalPath());
    }

    private List<String> reports() throws IOException {
        return Arrays.asList("-r", "junit=" + this.config.getOutput().getCanonicalPath(), "-r", "json=" + this.config.getOutput().getCanonicalPath());
    }

    private List<String> coverage() throws IOException {
        if (this.config.isCoverageEnabled()) {
            return Arrays.asList("-coverage", "src/main/dw", "-coverageReport", (Object)((Object)this.config.getCoverageFormat()) + "=" + this.config.getOutput().getCanonicalPath() + "/coverage");
        }
        return Collections.emptyList();
    }

    private List<String> aggregators() throws IOException {
        return this.config.isHtmlReport() ? Arrays.asList("-a", "html=" + this.config.getOutput().getCanonicalPath()) : Collections.emptyList();
    }

    public void setTests(WeaveTestMojoConfig config) {
        this.config = config;
    }
}

