/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.VersionUtils;

public class MuleArtifactJsonValidator {
    public static void validate(Path projectBaseDir, Optional<String> deployMuleVersion) throws ValidationException {
        MuleArtifactJsonValidator.isMuleArtifactJsonPresent(projectBaseDir);
        MuleArtifactJsonValidator.isMuleArtifactJsonValid(projectBaseDir, deployMuleVersion);
    }

    public static void isMuleArtifactJsonPresent(Path projectBaseDir) throws ValidationException {
        String errorMessage = "Invalid Mule project. Missing %s file, it must be present in the root of application";
        if (!projectBaseDir.resolve("mule-artifact.json").toFile().exists()) {
            throw new ValidationException(String.format(errorMessage, "mule-artifact.json"));
        }
    }

    public static void isMuleArtifactJsonValid(Path projectBaseDir, Optional<String> deployMuleVersion) throws ValidationException {
        MuleApplicationModel muleArtifact;
        File muleArtifactJsonFile = projectBaseDir.resolve("mule-artifact.json").toFile();
        try {
            muleArtifact = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleArtifactJsonFile, (String)null));
            if (muleArtifact == null) {
                throw new ValidationException("The mule-artifact.json file is empty");
            }
        }
        catch (JsonSyntaxException | IOException e) {
            throw new ValidationException(e);
        }
        MuleArtifactJsonValidator.validateMuleArtifactMandatoryFields(muleArtifact, deployMuleVersion);
    }

    protected static void validateMuleArtifactMandatoryFields(MuleApplicationModel muleArtifact, Optional<String> deployMuleVersion) throws ValidationException {
        ArrayList<String> missingFields = new ArrayList<String>();
        MuleArtifactJsonValidator.checkName(muleArtifact, missingFields);
        MuleArtifactJsonValidator.checkMinMuleVersionValue(muleArtifact, missingFields, deployMuleVersion);
        MuleArtifactJsonValidator.checkRequiredProduct(muleArtifact, missingFields);
        if (!missingFields.isEmpty()) {
            String message = "The following mandatory fields in the mule-artifact.json are missing or invalid: " + missingFields;
            if (missingFields.contains("requiredProduct")) {
                message = message + ". requiredProduct valid values are: MULE, MULE_EE";
            }
            throw new ValidationException(message);
        }
    }

    private static void checkRequiredProduct(MuleApplicationModel muleArtifact, List<String> missingFields) {
        Product requiredProduct = muleArtifact.getRequiredProduct();
        if (requiredProduct == null) {
            missingFields.add("requiredProduct");
        }
    }

    protected static void checkName(MuleApplicationModel muleArtifact, List<String> missingFields) {
        String nameValue = muleArtifact.getName();
        if (StringUtils.isBlank((CharSequence)nameValue)) {
            missingFields.add("name");
        }
    }

    protected static void checkMinMuleVersionValue(MuleApplicationModel muleArtifact, List<String> missingFields, Optional<String> deployMuleVersion) throws ValidationException {
        String minMuleVersionValue = muleArtifact.getMinMuleVersion();
        if (StringUtils.isBlank((CharSequence)minMuleVersionValue)) {
            missingFields.add("minMuleVersion");
        } else {
            MuleArtifactJsonValidator.isProjectVersionValid(minMuleVersionValue);
            if (deployMuleVersion != null && deployMuleVersion.isPresent() && StringUtils.isNotBlank((CharSequence)deployMuleVersion.get())) {
                MuleArtifactJsonValidator.areVersionCompatible(deployMuleVersion.get(), minMuleVersionValue);
            }
        }
    }

    private static void areVersionCompatible(String muleVersion, String minMuleVersion) throws ValidationException {
        MuleArtifactJsonValidator.isProjectVersionValid(muleVersion);
        String minMuleVersionBaseValue = VersionUtils.getBaseVersion(minMuleVersion);
        String muleVersionBaseValue = VersionUtils.getBaseVersion(muleVersion);
        if (!VersionUtils.isVersionGreaterOrEquals(muleVersionBaseValue, minMuleVersionBaseValue).booleanValue()) {
            throw new ValidationException("Mule version that is set in the deployment configuration is not compatible with the minMuleVersion in mule-artifact.json. deploymentConfiguration.muleVersion: " + muleVersion + ", minMuleVersion: " + minMuleVersion);
        }
    }

    private static void isProjectVersionValid(String version) throws ValidationException {
        if (!VersionUtils.isVersionValid(version).booleanValue()) {
            throw new ValidationException("Version " + version + " does not comply with semantic versioning specification");
        }
    }

    protected static void checkClassLoaderModelDescriptor(MuleApplicationModel muleArtifact, List<String> missingFields) {
        MuleArtifactLoaderDescriptor classLoaderModelDescriptor = muleArtifact.getClassLoaderModelLoaderDescriptor();
        if (classLoaderModelDescriptor == null) {
            missingFields.add("classLoaderModelLoaderDescriptor");
        }
        if (classLoaderModelDescriptor == null || StringUtils.isBlank((CharSequence)classLoaderModelDescriptor.getId())) {
            missingFields.add("classLoaderModelLoaderDescriptor.id");
        }
    }
}

