/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Parent;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.sources.DefaultValuesMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.DefaultValuesPolicyMuleArtifactJsonGenerator;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.sources.MulePolicyArtifactContentResolver;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.api.util.CopyFileVisitor;
import org.mule.tools.api.util.exclude.MuleExclusionMatcher;

public class MuleContentGenerator
extends ContentGenerator {
    private MuleArtifactContentResolver muleArtifactContentResolver;

    public MuleContentGenerator(ProjectInformation projectInformation, Parent parent) {
        super(projectInformation, parent);
    }

    @Override
    public void createContent() throws IOException {
        this.createMetaInfMuleSourceFolderContent();
        this.createDescriptors();
    }

    public void createMuleSrcFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.CLASSES.value());
        this.copyContent(originPath, destinationPath, Optional.empty(), true, false);
    }

    public void createAstFile(InputStream inputStream) throws IOException {
        File targetFile = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("artifact.ast").toFile();
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
    }

    public void createDwlFile(Set<String> dwlFiles) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        dwlFiles.stream().forEach(file -> {
            try {
                baos.write((file + "\n").getBytes());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        File targetFile = this.projectInformation.getBuildDirectory().resolve("dwlFile").toFile();
        FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(baos.toByteArray()), (File)targetFile);
    }

    public void createTestFolderContent() throws IOException {
        Path originPath = PackagingType.fromString(this.projectInformation.getPackaging()).getTestSourceFolderLocation(this.projectInformation.getProjectBaseFolder());
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.TEST_MULE.value()).resolve(originPath.getFileName());
        this.copyContent(originPath, destinationPath, Optional.empty(), false, true);
    }

    public void createMetaInfMuleSourceFolderContent() throws IOException {
        Path originPath = this.projectInformation.getProjectBaseFolder();
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_SRC.value()).resolve(this.projectInformation.getArtifactId());
        ArrayList<Path> exclusions = new ArrayList<Path>();
        exclusions.add(this.projectInformation.getBuildDirectory());
        this.copyContent(originPath, destinationPath, Optional.of(exclusions), true, true, true, true);
    }

    @Deprecated
    public void createApplicationClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel) {
        this.createApplicationClassLoaderModelJsonFile(classLoaderModel, true);
    }

    public void createApplicationClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, boolean prettyPrinting) {
        File destinationFolder = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).toFile();
        MuleContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, destinationFolder, prettyPrinting);
    }

    public void createApplicationClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, boolean prettyPrinting, File destinationFolder) {
        MuleContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, destinationFolder, prettyPrinting);
    }

    public static ClassLoaderModel createClassLoaderModelFromJson(File classLoaderModelDescriptor) {
        return ClassLoaderModelJsonSerializer.deserialize((File)classLoaderModelDescriptor);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions, Boolean validateOrigin, Boolean validateDestination) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, validateOrigin, validateDestination, Boolean.FALSE, Boolean.FALSE);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions, Boolean validateOrigin, Boolean validateDestination, Boolean ignoreHiddenFiles, Boolean ignoreHiddenFolders) throws IOException {
        if (validateOrigin.booleanValue()) {
            MuleContentGenerator.checkPathExist(originPath);
        }
        if (validateDestination.booleanValue()) {
            MuleContentGenerator.checkPathExist(destinationPath);
        }
        CopyFileVisitor visitor = new CopyFileVisitor(originPath.toFile(), destinationPath.toFile(), ignoreHiddenFiles, ignoreHiddenFolders, new MuleExclusionMatcher(this.projectInformation.getProjectBaseFolder()));
        exclusions.ifPresent(e -> visitor.setExclusions((List<Path>)e));
        Files.walkFileTree(originPath, visitor);
    }

    @Deprecated
    public static File createClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        return MuleContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, destinationFolder, true);
    }

    public static File createClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, File destinationFolder, boolean prettyPrinting) {
        return ClassLoaderModelJsonSerializer.serializeToFile((ClassLoaderModel)classLoaderModel, (File)destinationFolder, (boolean)prettyPrinting);
    }

    public void createDescriptors() throws IOException {
        this.createMavenDescriptors();
    }

    @Override
    public void copyDescriptorFile() throws IOException {
        Path originPath = this.projectInformation.getProjectBaseFolder().resolve("mule-artifact.json");
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value());
        String destinationFileName = originPath.getFileName().toString();
        MuleContentGenerator.copyFile(originPath, destinationPath, destinationFileName);
        if (Classifier.MULE_POLICY.equals(this.projectInformation.getClassifier())) {
            new DefaultValuesPolicyMuleArtifactJsonGenerator().generate(this.getMulePolicyArtifactContentResolver());
        } else {
            new DefaultValuesMuleArtifactJsonGenerator().generate(this.getMuleArtifactContentResolver());
        }
    }

    private MuleArtifactContentResolver getMulePolicyArtifactContentResolver() {
        if (this.muleArtifactContentResolver == null) {
            this.muleArtifactContentResolver = new MulePolicyArtifactContentResolver(this.getProjectStructure(), this.projectInformation.getEffectivePom(), this.projectInformation.getProject().getBundleDependencies());
        }
        return this.muleArtifactContentResolver;
    }

    private MuleArtifactContentResolver getMuleArtifactContentResolver() {
        if (this.muleArtifactContentResolver == null) {
            this.muleArtifactContentResolver = new MuleArtifactContentResolver(this.getProjectStructure(), this.projectInformation.getEffectivePom(), this.projectInformation.getProject().getBundleDependencies());
        }
        return this.muleArtifactContentResolver;
    }

    private ProjectStructure getProjectStructure() {
        return new ProjectStructure(this.projectInformation.getProjectBaseFolder(), this.projectInformation.getBuildDirectory(), this.projectInformation.isTestProject());
    }
}

