/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.sources.MuleApplicationModelExtended;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.structure.ProjectStructure;

public abstract class AbstractDefaultValuesMuleArtifactJsonGenerator {
    protected static final String MULE_ID = "mule";
    protected static final MuleApplicationModelJsonSerializer serializer = new MuleApplicationModelJsonSerializer();

    public void generate(MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Path muleArtifactJsonLocation = this.resolveMuleArtifactJsonLocation(muleArtifactContentResolver.getProjectStructure());
        this.generate(muleArtifactJsonLocation, muleArtifactJsonLocation, muleArtifactContentResolver);
    }

    public void generate(Path originFolder, Path destinationFolder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModelExtended originalMuleArtifactExtended = this.getOriginalMuleArtifact(originFolder);
        MuleApplicationModel generatedMuleArtifact = this.generateMuleArtifactWithDefaultValues(originalMuleArtifactExtended.getModel(), muleArtifactContentResolver);
        this.writeMuleArtifactExtendedToFile(new MuleApplicationModelExtended(generatedMuleArtifact, originalMuleArtifactExtended.getJavaSpecificationVersions()), destinationFolder);
    }

    private Path resolveMuleArtifactJsonLocation(ProjectStructure projectStructure) {
        return projectStructure.getMuleArtifactJsonPath();
    }

    private void writeMuleArtifactToFile(MuleApplicationModel muleArtifact, Path destinationFolder) throws IOException {
        String generatedMuleArtifactJsonContent = serializer.serialize((AbstractMuleArtifactModel)muleArtifact);
        File generatedMuleArtifactJson = new File(destinationFolder.toFile(), "mule-artifact.json");
        FileUtils.writeStringToFile((File)generatedMuleArtifactJson, (String)generatedMuleArtifactJsonContent, (String)null);
    }

    private MuleApplicationModelExtended getOriginalMuleArtifact(Path originFolder) throws IOException {
        HashSet<String> javaSpecificationVersions;
        File originalMuleArtifactJsonFile = originFolder.resolve("mule-artifact.json").toFile();
        String jsonContent = FileUtils.readFileToString((File)originalMuleArtifactJsonFile, (String)null);
        try {
            JsonObject jsonObject = JsonParser.parseString((String)jsonContent).getAsJsonObject();
            if (jsonObject.has("javaSpecificationVersions")) {
                JsonElement element = jsonObject.get("javaSpecificationVersions");
                javaSpecificationVersions = new HashSet<String>();
                if (element.isJsonArray()) {
                    JsonArray jsonArray = element.getAsJsonArray();
                    for (JsonElement arrayElement : jsonArray) {
                        javaSpecificationVersions.add(arrayElement.getAsString());
                    }
                } else if (element.isJsonPrimitive()) {
                    String stringValue = element.getAsString();
                    if (stringValue.contains(",")) {
                        javaSpecificationVersions.addAll(Arrays.asList(stringValue.split("\\s*,\\s*")));
                    } else {
                        javaSpecificationVersions.add(stringValue.trim());
                    }
                }
            } else {
                javaSpecificationVersions = null;
            }
        }
        catch (Exception e) {
            javaSpecificationVersions = null;
        }
        return new MuleApplicationModelExtended((MuleApplicationModel)serializer.deserialize(jsonContent), javaSpecificationVersions);
    }

    private MuleApplicationModel generateMuleArtifactWithDefaultValues(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleApplicationModel.MuleApplicationModelBuilder builder = this.getBuilderWithRequiredValues(originalMuleArtifact);
        this.setBuilderWithDefaultValuesNotPresent(builder, originalMuleArtifact, muleArtifactContentResolver);
        return (MuleApplicationModel)builder.build();
    }

    private void setBuilderWithDefaultValuesNotPresent(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        this.setBuilderWithDefaultName(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithDefaultSecureProperties(builder, originalMuleArtifact);
        this.setBuilderWithDefaultRedeploymentEnabled(builder, originalMuleArtifact);
        this.setBuilderWithDefaultConfigsValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithDefaultRequiredProduct(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithDefaultExportedResourcesValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        this.setBuilderWithIncludeTestDependencies(builder, muleArtifactContentResolver);
        this.setBuilderWithDefaultBundleDescriptorLoaderValue(builder, originalMuleArtifact, muleArtifactContentResolver);
        if (originalMuleArtifact.getLogConfigFile() != null) {
            builder.setLogConfigFile(originalMuleArtifact.getLogConfigFile());
        }
    }

    protected abstract void setBuilderWithDefaultRequiredProduct(MuleApplicationModel.MuleApplicationModelBuilder var1, MuleApplicationModel var2, MuleArtifactContentResolver var3) throws IOException;

    protected abstract void setBuilderWithDefaultExportedResourcesValue(MuleApplicationModel.MuleApplicationModelBuilder var1, MuleApplicationModel var2, MuleArtifactContentResolver var3) throws IOException;

    protected abstract void setBuilderWithDefaultBundleDescriptorLoaderValue(MuleApplicationModel.MuleApplicationModelBuilder var1, MuleApplicationModel var2, MuleArtifactContentResolver var3);

    protected void setBuilderWithDefaultSecureProperties(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        ArrayList secureProperties = originalMuleArtifact.getSecureProperties();
        if (secureProperties == null) {
            secureProperties = new ArrayList();
        }
        builder.setSecureProperties((List)secureProperties);
    }

    protected void setBuilderWithDefaultName(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) {
        String name = originalMuleArtifact.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            Pom pom = muleArtifactContentResolver.getPom();
            name = pom.getGroupId() + ":" + pom.getArtifactId() + ":" + pom.getVersion();
        }
        builder.setName(name);
    }

    protected void setBuilderWithIncludeTestDependencies(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        MuleArtifactLoaderDescriptor descriptorLoader = builder.getClassLoaderModelDescriptorLoader();
        if (muleArtifactContentResolver.getProjectStructure().getTestConfigsPath().isPresent()) {
            Map<String, Object> attributesCopy = this.getUpdatedAttributes(descriptorLoader, "includeTestDependencies", "true");
            builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(descriptorLoader.getId(), attributesCopy));
        }
    }

    protected abstract void setBuilderWithDefaultExportedPackagesValue(MuleApplicationModel.MuleApplicationModelBuilder var1, MuleApplicationModel var2, MuleArtifactContentResolver var3) throws IOException;

    protected void setBuilderWithDefaultConfigsValue(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        Set<String> configs = this.getConfigs(originalMuleArtifact, muleArtifactContentResolver);
        configs.addAll(muleArtifactContentResolver.getTestConfigs());
        builder.setConfigs(configs);
    }

    protected void setBuilderWithDefaultRedeploymentEnabled(MuleApplicationModel.MuleApplicationModelBuilder builder, MuleApplicationModel originalMuleArtifact) {
        builder.setRedeploymentEnabled(originalMuleArtifact.isRedeploymentEnabled());
    }

    protected MuleApplicationModel.MuleApplicationModelBuilder getBuilderWithRequiredValues(MuleApplicationModel muleArtifact) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = new MuleApplicationModel.MuleApplicationModelBuilder();
        builder.setMinMuleVersion(muleArtifact.getMinMuleVersion());
        return builder;
    }

    protected Set<String> getConfigs(MuleApplicationModel originalMuleArtifact, MuleArtifactContentResolver muleArtifactContentResolver) throws IOException {
        HashSet<String> configs = new HashSet<String>();
        if (originalMuleArtifact.getConfigs() != null) {
            configs.addAll(originalMuleArtifact.getConfigs());
        } else {
            configs.addAll(muleArtifactContentResolver.getConfigs());
        }
        return configs;
    }

    protected Map<String, Object> getUpdatedAttributes(MuleArtifactLoaderDescriptor descriptorLoader, String attribute, Object value) {
        Map originalAttributes = descriptorLoader.getAttributes();
        HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
        if (originalAttributes != null) {
            attributesCopy.putAll(originalAttributes);
        }
        attributesCopy.put(attribute, value);
        return attributesCopy;
    }

    public void writeMuleArtifactExtendedToFile(MuleApplicationModelExtended extendedMuleArtifact, Path destinationFolder) throws IOException {
        String finalJsonContent;
        String originalJsonContent = serializer.serialize((AbstractMuleArtifactModel)extendedMuleArtifact.getModel());
        try {
            JsonObject jsonObject = JsonParser.parseString((String)originalJsonContent).getAsJsonObject();
            if (extendedMuleArtifact.getJavaSpecificationVersions() != null && !extendedMuleArtifact.getJavaSpecificationVersions().isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (String version : extendedMuleArtifact.getJavaSpecificationVersions()) {
                    jsonArray.add(version);
                }
                jsonObject.add("javaSpecificationVersions", (JsonElement)jsonArray);
            }
            Gson gson = new Gson().newBuilder().setPrettyPrinting().create();
            finalJsonContent = gson.toJson((JsonElement)jsonObject);
        }
        catch (Exception e) {
            finalJsonContent = originalJsonContent;
        }
        File generatedMuleArtifactJson = new File(destinationFolder.toFile(), "mule-artifact.json");
        FileUtils.writeStringToFile((File)generatedMuleArtifactJson, (String)finalJsonContent, (String)null);
    }
}

