/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.project;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.validation.project.AbstractProjectValidator;

public class DomainBundleProjectValidator
extends AbstractProjectValidator {
    private static final int DOMAIN_BUNDLE_VALID_NUMBER_OF_DOMAINS = 1;
    private final MavenClient mavenClient;

    public DomainBundleProjectValidator(ProjectInformation defaultProjectInformation, MavenClient mavenClient) {
        super(defaultProjectInformation, false);
        this.mavenClient = mavenClient;
    }

    @Override
    protected void additionalValidation() throws ValidationException {
        Set<ArtifactCoordinates> domains = this.projectInformation.getProject().getDirectDependencies().stream().filter(d -> PackagingType.MULE_DOMAIN.equals(d.getClassifier())).collect(Collectors.toSet());
        this.validateDomain(domains);
        List<ArtifactCoordinates> applications = this.projectInformation.getProject().getDirectDependencies().stream().filter(d -> !PackagingType.MULE_DOMAIN.equals(d.getClassifier())).collect(Collectors.toList());
        this.validateApplications(domains.iterator().next(), applications);
    }

    @Override
    protected void isDeploymentValid() throws ValidationException {
    }

    protected void validateApplications(ArtifactCoordinates domain, List<ArtifactCoordinates> applications) throws ValidationException {
        if (applications == null || applications.isEmpty()) {
            throw new ValidationException("A domain bundle should contain at least one application");
        }
        for (ArtifactCoordinates applicationCoordinates : applications) {
            this.validateApplication(domain, applicationCoordinates);
        }
    }

    protected void validateApplication(ArtifactCoordinates domain, ArtifactCoordinates applicationCoordinates) throws ValidationException {
        Set<ArtifactCoordinates> applicationDomains = this.getApplicationDomains(applicationCoordinates);
        if (applicationDomains.size() != 1 || !applicationDomains.contains(domain)) {
            String message = "Every application in the domain bundle must refer to the specified domain: " + domain + ". ";
            message = applicationDomains.isEmpty() ? message + "However, the application: " + applicationCoordinates.toString() + " has reference to no domain" : message + "However, the application: " + applicationCoordinates.toString() + " refers to the following domain(s): " + applicationDomains.stream().collect(Collectors.toList());
            throw new ValidationException(message);
        }
    }

    protected Set<ArtifactCoordinates> getApplicationDomains(ArtifactCoordinates applicationCoordinates) {
        List<BundleDependency> applicationDependencies = this.resolveApplicationDependencies(applicationCoordinates);
        return this.getMuleDomains(applicationDependencies);
    }

    protected List<BundleDependency> resolveApplicationDependencies(ArtifactCoordinates applicationCoordinates) {
        return this.mavenClient.resolveBundleDescriptorDependencies(false, true, ArtifactUtils.toBundleDescriptor(applicationCoordinates));
    }

    protected Set<ArtifactCoordinates> getMuleDomains(List<BundleDependency> bundleDependencies) {
        return bundleDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getClassifier().isPresent()).filter(bundleDependency -> ((String)bundleDependency.getDescriptor().getClassifier().get()).equals(PackagingType.MULE_DOMAIN.toString())).map(ArtifactUtils::toArtifact).map(Artifact::getArtifactCoordinates).collect(Collectors.toSet());
    }

    protected void validateDomain(Set<ArtifactCoordinates> domains) throws ValidationException {
        Preconditions.checkArgument((domains != null ? 1 : 0) != 0, (Object)"Set of domains should not be null");
        if (!domains.stream().allMatch(artifactCoordinates -> StringUtils.equals((CharSequence)artifactCoordinates.getClassifier(), (CharSequence)PackagingType.MULE_DOMAIN.toString()))) {
            String message = "Not all dependencies are mule domains";
            throw new ValidationException(message);
        }
        if (domains.size() != 1) {
            String message = "A mule domain bundle must contain exactly one mule domain. ";
            message = domains.isEmpty() ? message + "However, the project has no reference to domains in its dependencies." : message + "However, the project has reference to the following domains: " + new ArrayList<ArtifactCoordinates>(domains);
            throw new ValidationException(message);
        }
    }
}

