/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.resources.generator;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;
import org.mule.tools.api.packager.resources.content.DomainBundleProjectResourcesContent;
import org.mule.tools.api.packager.resources.content.ResourcesContent;
import org.mule.tools.api.packager.resources.generator.ResourcesContentGenerator;

public class DomainBundleProjectResourcesContentGenerator
implements ResourcesContentGenerator {
    private final MavenClient mavenClient;
    private final List<ArtifactCoordinates> projectDependencies;

    public DomainBundleProjectResourcesContentGenerator(MavenClient mavenClient, List<ArtifactCoordinates> projectDependencies) {
        this.mavenClient = mavenClient;
        this.projectDependencies = projectDependencies;
    }

    @Override
    public ResourcesContent generate() {
        DomainBundleProjectResourcesContent resourcesContent = new DomainBundleProjectResourcesContent();
        List dependenciesBundleDescriptors = this.projectDependencies.stream().map(ArtifactUtils::toBundleDescriptor).collect(Collectors.toList());
        for (BundleDescriptor bundleDescriptor : dependenciesBundleDescriptors) {
            BundleDependency dependency = this.mavenClient.resolveBundleDescriptor(bundleDescriptor);
            resourcesContent.add(ArtifactUtils.toArtifact(dependency));
        }
        return resourcesContent;
    }
}

