/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.exchange.ExchangeRepositoryMetadata;
import org.mule.tools.model.Deployment;

public class DefaultProjectInformation
implements ProjectInformation {
    private String groupId;
    private String artifactId;
    private String packaging;
    private String version;
    private final String classifier;
    private Path projectBaseFolder;
    private Path buildDirectory;
    private boolean isTestProject;
    private Project project;
    private boolean isDeployment;
    private List<Deployment> deployments;
    private ExchangeRepositoryMetadata metadata;
    private Pom resolvedPom;

    private DefaultProjectInformation(String groupId, String artifactId, String version, String classifier, String packaging, Path projectBaseFolder, Path buildDirectory, boolean isTestProject, Project project, boolean isDeployment, ExchangeRepositoryMetadata metadata, List<Deployment> deployments, Pom resolvedPom) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.packaging = packaging;
        this.projectBaseFolder = projectBaseFolder;
        this.buildDirectory = buildDirectory;
        this.isTestProject = isTestProject;
        this.project = project;
        this.isDeployment = isDeployment;
        this.metadata = metadata;
        this.deployments = deployments;
        this.resolvedPom = resolvedPom;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public Path getProjectBaseFolder() {
        return this.projectBaseFolder;
    }

    @Override
    public Path getBuildDirectory() {
        return this.buildDirectory;
    }

    @Override
    public boolean isTestProject() {
        return this.isTestProject;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Optional<ExchangeRepositoryMetadata> getExchangeRepositoryMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public boolean isDeployment() {
        return this.isDeployment;
    }

    @Override
    public List<Deployment> getDeployments() {
        return this.deployments;
    }

    @Override
    public Pom getEffectivePom() {
        return this.resolvedPom;
    }

    public List<BundleDependency> getBundleDependencies() {
        return this.project.getBundleDependencies();
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String packaging;
        private Path projectBaseFolder;
        private Path buildDirectory;
        private Boolean isTestProject;
        private Project project;
        private boolean isDeployment;
        private ExchangeRepositoryMetadata metadata;
        private String classifier;
        private List<Deployment> deployments;
        private Pom resolvedPom;

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withPackaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        public Builder withProjectBaseFolder(Path projectBaseFolder) {
            this.projectBaseFolder = projectBaseFolder;
            return this;
        }

        public Builder withBuildDirectory(Path buildDirectory) {
            this.buildDirectory = buildDirectory;
            return this;
        }

        public Builder setTestProject(Boolean isTestProject) {
            this.isTestProject = isTestProject;
            return this;
        }

        public Builder withDependencyProject(Project project) {
            this.project = project;
            return this;
        }

        public Builder isDeployment(boolean isDeployment) {
            this.isDeployment = isDeployment;
            return this;
        }

        public Builder withExchangeRepositoryMetadata(ExchangeRepositoryMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder withDeployments(List<Deployment> deployments) {
            this.deployments = deployments;
            return this;
        }

        public Builder withResolvedPom(Pom pom) {
            this.resolvedPom = pom;
            return this;
        }

        public DefaultProjectInformation build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupId), (Object)"Group id should not be null nor blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.artifactId), (Object)"Artifact id should not be null nor blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.version), (Object)"Version should not be null nor blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.packaging), (Object)"Packaging should not be null nor blank");
            Preconditions.checkArgument((this.projectBaseFolder != null ? 1 : 0) != 0, (Object)"Project base folder should not be null");
            Preconditions.checkArgument((this.buildDirectory != null ? 1 : 0) != 0, (Object)"Project build directory should not be null");
            Preconditions.checkArgument((this.isTestProject != null ? 1 : 0) != 0, (Object)"Project isTestProject property was not set");
            Preconditions.checkArgument((this.resolvedPom != null ? 1 : 0) != 0, (Object)"Project pom was not set");
            return new DefaultProjectInformation(this.groupId, this.artifactId, this.version, this.classifier, this.packaging, this.projectBaseFolder, this.buildDirectory, this.isTestProject, this.project, this.isDeployment, this.metadata, this.deployments, this.resolvedPom);
        }
    }
}

