/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import org.apache.maven.model.Dependency;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class ArtifactUtils {
    public static ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), (String)bundleDescriptor.getClassifier().orElse(null));
        return artifactCoordinates;
    }

    public static Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = ArtifactUtils.toArtifactCoordinates(bundleDependency.getDescriptor());
        return new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
    }

    public static Dependency toDependency(ArtifactCoordinates artifactCoordinates) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifactCoordinates.getGroupId());
        dependency.setArtifactId(artifactCoordinates.getArtifactId());
        dependency.setVersion(artifactCoordinates.getVersion());
        dependency.setType(artifactCoordinates.getType());
        dependency.setClassifier(artifactCoordinates.getClassifier());
        dependency.setScope(artifactCoordinates.getScope());
        return dependency;
    }

    public static ArtifactCoordinates toArtifactCoordinates(Dependency dependency) {
        return new ArtifactCoordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier(), dependency.getScope());
    }

    public static ArtifactCoordinates toArtifactCoordinates(org.apache.maven.artifact.Artifact artifact) {
        return new ArtifactCoordinates(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope());
    }

    public static BundleDescriptor toBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setGroupId(artifactCoordinates.getGroupId()).setArtifactId(artifactCoordinates.getArtifactId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setClassifier(artifactCoordinates.getClassifier()).setType(artifactCoordinates.getType()).build();
    }
}

