/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tools.api.classloader.model.ApplicationGAVModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.util.FileJarExplorer;
import org.mule.tools.api.util.JarInfo;

public class ArtifactUtils {
    private static final String PACKAGE_TYPE = "jar";
    private static final String PROVIDED = "provided";
    private static final URI EMPTY_RESOURCE = URI.create("");
    private static final String POM_TYPE = "pom";

    public static ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), (String)bundleDescriptor.getClassifier().orElse(null));
        return artifactCoordinates;
    }

    public static Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = ArtifactUtils.toArtifactCoordinates(bundleDependency.getDescriptor());
        return new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
    }

    public static List<Artifact> toArtifacts(Collection<BundleDependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifact).collect(Collectors.toList());
    }

    public static boolean isValidMulePlugin(Artifact artifact) {
        ArtifactCoordinates pluginCoordinates = artifact.getArtifactCoordinates();
        Optional<String> pluginClassifier = Optional.ofNullable(pluginCoordinates.getClassifier());
        return pluginClassifier.isPresent() && "mule-plugin".equals(pluginClassifier.get());
    }

    public static BundleDescriptor toBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setGroupId(artifactCoordinates.getGroupId()).setArtifactId(artifactCoordinates.getArtifactId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setClassifier(artifactCoordinates.getClassifier()).setType(artifactCoordinates.getType()).build();
    }

    public static BundleDescriptor toBundleDescriptor(Dependency dependency) {
        return new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setBaseVersion(dependency.getVersion()).setClassifier(dependency.getClassifier()).setType(dependency.getType()).build();
    }

    public static List<Artifact> toApplicationModelArtifacts(List<BundleDependency> appDependencies) {
        List<Artifact> dependencies = ArtifactUtils.toArtifacts(appDependencies);
        dependencies.forEach(ArtifactUtils::updateScopeIfDomain);
        return dependencies;
    }

    public static List<Artifact> updatePackagesResources(List<Artifact> artifacts) {
        return artifacts.stream().map(artifact -> ArtifactUtils.updatePackagesResources(artifact)).collect(Collectors.toList());
    }

    public static Artifact updatePackagesResources(Artifact artifact) {
        if (Classifier.MULE_PLUGIN.equals(artifact.getArtifactCoordinates().getClassifier()) || artifact.getUri() == null || StringUtils.isBlank((CharSequence)artifact.getUri().getPath())) {
            return artifact;
        }
        JarInfo jarInfo = new FileJarExplorer().explore(artifact.getUri());
        artifact.setPackages(jarInfo.getPackages().toArray(new String[jarInfo.getPackages().size()]));
        artifact.setResources(jarInfo.getResources().toArray(new String[jarInfo.getResources().size()]));
        return artifact;
    }

    public static List<Artifact> updateArtifactsSharedState(List<BundleDependency> appDependencies, List<Artifact> artifacts, Model pomModel, List<String> activeProfiles) {
        ArrayList<Build> builds = new ArrayList<Build>();
        if (pomModel.getBuild() != null) {
            builds.add(pomModel.getBuild());
        }
        pomModel.getProfiles().forEach(p -> {
            if (activeProfiles.contains(p.getId())) {
                builds.add((Build)p.getBuild());
            }
        });
        if (!builds.isEmpty()) {
            ArrayList plugins = new ArrayList();
            builds.forEach(b -> {
                if (b != null) {
                    plugins.addAll(b.getPlugins());
                }
            });
            if (!plugins.isEmpty()) {
                Optional<Plugin> muleMavenPluginOptional = plugins.stream().filter(plugin -> plugin.getGroupId().equalsIgnoreCase("org.mule.tools.maven") && plugin.getArtifactId().equalsIgnoreCase("mule-maven-plugin")).findAny();
                muleMavenPluginOptional.ifPresent(plugin -> {
                    Xpp3Dom[] sharedLibraries;
                    Xpp3Dom sharedLibrariesDom;
                    Object configuration = plugin.getConfiguration();
                    if (configuration != null && (sharedLibrariesDom = ((Xpp3Dom)configuration).getChild("sharedLibraries")) != null && (sharedLibraries = sharedLibrariesDom.getChildren("sharedLibrary")) != null) {
                        for (Xpp3Dom sharedLibrary : sharedLibraries) {
                            String groupId = ArtifactUtils.getAttribute(sharedLibrary, "groupId");
                            String artifactId = ArtifactUtils.getAttribute(sharedLibrary, "artifactId");
                            ArtifactUtils.findAndExportSharedLibrary(groupId, artifactId, artifacts, appDependencies);
                        }
                    }
                });
            }
        }
        return artifacts;
    }

    private static void findAndExportSharedLibrary(String sharedLibraryGroupId, String sharedLibraryArtifactId, List<Artifact> artifacts, List<BundleDependency> appDependencies) {
        appDependencies.stream().forEach(bundleDependency -> {
            if (bundleDependency.getDescriptor().getGroupId().equals(sharedLibraryGroupId) && bundleDependency.getDescriptor().getArtifactId().equals(sharedLibraryArtifactId)) {
                ArtifactUtils.setArtifactTransitiveDependenciesAsShared(artifacts, bundleDependency);
            }
        });
    }

    private static void setArtifactTransitiveDependenciesAsShared(List<Artifact> artifacts, BundleDependency bundleDependency) {
        ArtifactUtils.setArtifactAsShared(bundleDependency.getDescriptor().getGroupId(), bundleDependency.getDescriptor().getArtifactId(), artifacts);
        bundleDependency.getTransitiveDependencies().stream().forEach(transitiveDependency -> ArtifactUtils.setArtifactTransitiveDependenciesAsShared(artifacts, transitiveDependency));
    }

    private static void setArtifactAsShared(String sharedLibraryGroupId, String sharedLibraryArtifactId, List<Artifact> artifacts) {
        artifacts.stream().forEach(artifact -> {
            if (artifact.getArtifactCoordinates().getGroupId().equals(sharedLibraryGroupId) && artifact.getArtifactCoordinates().getArtifactId().equals(sharedLibraryArtifactId)) {
                artifact.setShared(true);
            }
        });
    }

    protected static String getAttribute(Xpp3Dom tag, String attributeName) {
        Xpp3Dom attributeDom = tag.getChild(attributeName);
        Preconditions.checkState((attributeDom != null ? 1 : 0) != 0, (String)String.format("'%s' element not declared at '%s' in the pom file", attributeName, tag.toString()));
        String attributeValue = attributeDom.getValue().trim();
        Preconditions.checkState((!StringUtils.isEmpty((CharSequence)attributeValue) ? 1 : 0) != 0, (String)String.format("'%s' was defined but has an empty value at '%s' declared in the pom file", attributeName, tag.toString()));
        return attributeValue;
    }

    public static void updateScopeIfDomain(Artifact artifact) {
        String classifier = artifact.getArtifactCoordinates().getClassifier();
        if (StringUtils.equals((CharSequence)classifier, (CharSequence)Classifier.MULE_DOMAIN.toString())) {
            artifact.getArtifactCoordinates().setScope(PROVIDED);
            artifact.setUri(EMPTY_RESOURCE);
        }
    }

    public static ArtifactCoordinates getApplicationArtifactCoordinates(Model pomModel, ApplicationGAVModel appGAVModel) {
        ArtifactCoordinates appCoordinates = ArtifactUtils.toArtifactCoordinates(ArtifactUtils.getPomProjectBundleDescriptor(appGAVModel));
        appCoordinates.setType(PACKAGE_TYPE);
        appCoordinates.setClassifier(pomModel.getPackaging());
        return appCoordinates;
    }

    public static BundleDescriptor getPomProjectBundleDescriptor(ApplicationGAVModel appGAVModel) {
        return ArtifactUtils.getBundleDescriptor(appGAVModel);
    }

    public static BundleDescriptor getBundleDescriptor(ApplicationGAVModel appGAVModel) {
        return new BundleDescriptor.Builder().setGroupId(appGAVModel.getGroupId()).setArtifactId(appGAVModel.getArtifactId()).setVersion(appGAVModel.getVersion()).setBaseVersion(appGAVModel.getVersion()).setType(POM_TYPE).build();
    }
}

