/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.structure.FolderNames;

public abstract class ContentGenerator {
    protected final ProjectInformation projectInformation;

    public ContentGenerator(ProjectInformation projectInformation) {
        Preconditions.checkArgument((boolean)projectInformation.getProjectBaseFolder().toFile().exists(), (Object)"Project base folder should exist");
        Preconditions.checkArgument((boolean)projectInformation.getBuildDirectory().toFile().exists(), (Object)"Project build folder should exist");
        this.projectInformation = projectInformation;
    }

    public abstract void createContent() throws IOException;

    public void copyDescriptorFile() throws IOException {
    }

    protected void copyPomFile() throws IOException {
        Path originPath = this.projectInformation.getProjectBaseFolder().resolve("pom.xml");
        Path destinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MAVEN.value()).resolve(this.projectInformation.getGroupId()).resolve(this.projectInformation.getArtifactId());
        String destinationFileName = originPath.getFileName().toString();
        ContentGenerator.copyFile(originPath, destinationPath, destinationFileName);
    }

    public static void checkPathExist(Path path) {
        Preconditions.checkArgument((boolean)path.toFile().exists(), (Object)("The path: " + path.toString() + " should exist"));
    }

    public static void copyFile(Path originPath, Path destinationPath, String destinationFileName) throws IOException {
        ContentGenerator.checkPathExist(originPath);
        ContentGenerator.checkPathExist(destinationPath);
        Files.copy(originPath, destinationPath.resolve(destinationFileName), StandardCopyOption.REPLACE_EXISTING);
    }

    protected void createPomProperties() {
        Path pomPropertiesDestinationPath = this.projectInformation.getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MAVEN.value()).resolve(this.projectInformation.getGroupId()).resolve(this.projectInformation.getArtifactId());
        ContentGenerator.checkPathExist(pomPropertiesDestinationPath);
        Path pomPropertiesFilePath = pomPropertiesDestinationPath.resolve("pom.properties");
        try {
            PrintWriter writer = new PrintWriter(pomPropertiesFilePath.toString(), "UTF-8");
            writer.println("version=" + this.projectInformation.getVersion());
            writer.println("groupId=" + this.projectInformation.getGroupId());
            writer.println("artifactId=" + this.projectInformation.getArtifactId());
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create pom.properties", e);
        }
    }

    protected void createMavenDescriptors() throws IOException {
        this.copyPomFile();
        this.createPomProperties();
    }
}

