/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.archiver.AbstractArchiver;
import org.mule.tools.api.packager.archiver.DomainBundleArchiver;
import org.mule.tools.api.packager.builder.PackageBuilder;
import org.mule.tools.api.packager.structure.FolderNames;

public class DomainBundlePackageBuilder
implements PackageBuilder {
    private File domainFolder = null;
    private File applicationsFolder = null;
    private File mavenFolder = null;
    private DomainBundleArchiver archiver;

    public DomainBundlePackageBuilder withMaven(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exist");
        this.mavenFolder = folder;
        return this;
    }

    public DomainBundlePackageBuilder withDomain(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exist");
        this.domainFolder = folder;
        return this;
    }

    public DomainBundlePackageBuilder withApplications(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        Preconditions.checkArgument((boolean)folder.exists(), (Object)"The folder must exist");
        this.applicationsFolder = folder;
        return this;
    }

    public DomainBundlePackageBuilder withArchiver(AbstractArchiver archiver) {
        Preconditions.checkArgument((archiver != null ? 1 : 0) != 0, (Object)"Archiver must not be null");
        this.archiver = (DomainBundleArchiver)archiver;
        return this;
    }

    @Override
    public void createPackage(Path originFolderPath, Path destinationPath) throws ArchiverException, IOException {
        Preconditions.checkArgument((originFolderPath != null ? 1 : 0) != 0, (Object)"The origin path must not be null");
        Preconditions.checkArgument((boolean)originFolderPath.toFile().exists(), (Object)"The origin path must exist");
        Path metaInfPath = originFolderPath.resolve(FolderNames.META_INF.value());
        this.withDomain(originFolderPath.resolve(FolderNames.DOMAIN.value()).toFile()).withApplications(originFolderPath.resolve(FolderNames.APPLICATIONS.value()).toFile()).withMaven(metaInfPath.resolve(FolderNames.MAVEN.value()).toFile());
        this.createArchive(destinationPath);
    }

    @Override
    public void createPackage(Path destinationPath) throws ArchiverException, IOException {
        this.createArchive(destinationPath);
    }

    private void createArchive(Path destinationPath) throws IOException {
        Preconditions.checkArgument((destinationPath != null ? 1 : 0) != 0, (Object)"The destination path must not be null");
        Preconditions.checkArgument((!destinationPath.toFile().exists() ? 1 : 0) != 0, (Object)"The destination file must not be duplicated");
        this.validateState();
        DomainBundleArchiver archiver = this.getArchiver();
        archiver.addDomain(this.domainFolder, null, null);
        archiver.addApplications(this.applicationsFolder, null, null);
        archiver.addMaven(this.mavenFolder, null, null);
        archiver.setDestFile(destinationPath.toFile());
        archiver.createArchive();
    }

    private void validateState() {
        this.isValidFolder(this.domainFolder, "The domain folders has not been properly defined");
        this.isValidFolder(this.applicationsFolder, "The applications folders has not been properly defined");
        this.isValidFolder(this.mavenFolder, "The maven folders has not been properly defined");
    }

    private void isValidFolder(File file, String message) {
        Preconditions.checkState((file != null && file.exists() && file.isDirectory() ? 1 : 0) != 0, (Object)message);
    }

    protected DomainBundleArchiver getArchiver() {
        if (this.archiver == null) {
            this.archiver = new DomainBundleArchiver();
        }
        return this.archiver;
    }
}

