/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.packaging;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.structure.FolderNames;

public enum PackagingType {
    MULE_APPLICATION(Classifier.MULE_APPLICATION){

        @Override
        public Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_APPLICATION, Classifier.MULE_PLUGIN, Classifier.MULE_APPLICATION_EXAMPLE, Classifier.MULE_APPLICATION_TEMPLATE};
        }
    }
    ,
    MULE_DOMAIN(Classifier.MULE_DOMAIN){

        @Override
        public Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_DOMAIN};
        }
    }
    ,
    MULE_POLICY(Classifier.MULE_POLICY){

        @Override
        public Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_POLICY};
        }
    }
    ,
    MULE_DOMAIN_BUNDLE(Classifier.MULE_DOMAIN_BUNDLE){

        @Override
        public Classifier[] getClassifiers() {
            return new Classifier[]{Classifier.MULE_DOMAIN_BUNDLE};
        }
    };

    protected Classifier defaultClassifier;

    private PackagingType(Classifier defaultClassifier) {
        this.defaultClassifier = defaultClassifier;
    }

    public abstract Classifier[] getClassifiers();

    public String resolveClassifier(String classifierName, boolean lightweight, boolean testPackage) {
        String baseClassifier = Arrays.stream(this.getClassifiers()).filter(allowedClassifier -> allowedClassifier.equals(classifierName)).findFirst().orElse(this.defaultClassifier).toString();
        if (lightweight) {
            baseClassifier = baseClassifier + "-" + Classifier.LIGHT_PACKAGE.toString();
        }
        if (testPackage) {
            baseClassifier = baseClassifier + "-" + (Object)((Object)Classifier.TEST_JAR);
        }
        return baseClassifier;
    }

    public static PackagingType fromString(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Packaging type name should not be null");
        String packagingName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        return PackagingType.valueOf(packagingName);
    }

    public boolean equals(String name) {
        return name == null ? false : PackagingType.fromString(name).equals((Object)this);
    }

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public Path getSourceFolderLocation(Path projectBaseFolder) {
        return Paths.get(this.mainFolder(projectBaseFolder).getAbsolutePath(), this.getSourceFolderName());
    }

    public Path getTestSourceFolderLocation(Path projectBaseFolder) {
        return this.testFolder(projectBaseFolder).toPath().resolve(this.getTestFolderName());
    }

    public String getTestFolderName() {
        return FolderNames.MUNIT.value();
    }

    public String getSourceFolderName() {
        return FolderNames.MULE.value();
    }

    private File mainFolder(Path projectBaseFolder) {
        return Paths.get(this.srcFolder(projectBaseFolder).getAbsolutePath(), FolderNames.MAIN.value()).toFile();
    }

    private File testFolder(Path projectBaseFolder) {
        return Paths.get(this.srcFolder(projectBaseFolder).getAbsolutePath(), FolderNames.TEST.value()).toFile();
    }

    private File srcFolder(Path projectBaseFolder) {
        Preconditions.checkArgument((projectBaseFolder != null ? 1 : 0) != 0, (Object)"Project base folder should not be null");
        return Paths.get(projectBaseFolder.toFile().getAbsolutePath(), FolderNames.SRC.value()).toFile();
    }
}

