/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.exchange;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tools.client.authentication.model.Credentials;

public class ExchangeRepositoryMetadata {
    private static final Pattern exchangeRepositoryUriPattern = Pattern.compile("^https://.*anypoint\\.mulesoft\\.com/api/v1/organizations/(.*)/maven$");
    private static final Pattern anypointPrefixUriPattern = Pattern.compile("^https://maven\\.(.*anypoint\\.mulesoft\\.com/)");
    private String baseUri;
    private String organizationId;
    private Credentials credentials;

    public ExchangeRepositoryMetadata() {
    }

    public ExchangeRepositoryMetadata(Credentials credentials, String uri) {
        this.credentials = credentials;
        this.parseUri(uri);
    }

    private void parseUri(String uri) {
        this.baseUri = this.getBaseUri(uri);
        this.organizationId = this.getOrganizationId(uri);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public static boolean isExchangeRepo(String uri) {
        return exchangeRepositoryUriPattern.matcher(uri).matches();
    }

    protected String getBaseUri(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (String)"URI should not be null");
        String baseUri = null;
        Matcher matcher = anypointPrefixUriPattern.matcher(uri);
        if (matcher.find()) {
            baseUri = "https://" + matcher.group(1);
        }
        if (baseUri == null) {
            throw new IllegalArgumentException("The URI " + uri + " is not a valid URI to Exchange");
        }
        return baseUri;
    }

    protected String getOrganizationId(String uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (String)"URI should not be null");
        String organizationId = null;
        Matcher matcher = exchangeRepositoryUriPattern.matcher(uri);
        if (matcher.matches()) {
            organizationId = matcher.group(1);
        }
        if (organizationId == null) {
            throw new IllegalArgumentException("The URI " + uri + " is not a valid URI to Exchange");
        }
        return organizationId;
    }
}

