/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.util;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.packager.packaging.Classifier;

public class ArtifactUtils {
    private static final String PACKAGE_TYPE = "jar";
    private static final String PROVIDED = "provided";
    private static final URI EMPTY_RESOURCE = URI.create("");
    private static final String POM_TYPE = "pom";

    public static ArtifactCoordinates toArtifactCoordinates(BundleDescriptor bundleDescriptor) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), bundleDescriptor.getBaseVersion(), bundleDescriptor.getType(), (String)bundleDescriptor.getClassifier().orElse(null));
        return artifactCoordinates;
    }

    public static Artifact toArtifact(BundleDependency bundleDependency) {
        ArtifactCoordinates artifactCoordinates = ArtifactUtils.toArtifactCoordinates(bundleDependency.getDescriptor());
        return new Artifact(artifactCoordinates, bundleDependency.getBundleUri());
    }

    public static List<Artifact> toArtifacts(Collection<BundleDependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifact).collect(Collectors.toList());
    }

    public static boolean isValidMulePlugin(Artifact artifact) {
        ArtifactCoordinates pluginCoordinates = artifact.getArtifactCoordinates();
        Optional<String> pluginClassifier = Optional.ofNullable(pluginCoordinates.getClassifier());
        return pluginClassifier.isPresent() && "mule-plugin".equals(pluginClassifier.get());
    }

    public static BundleDescriptor toBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setGroupId(artifactCoordinates.getGroupId()).setArtifactId(artifactCoordinates.getArtifactId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setClassifier(artifactCoordinates.getClassifier()).setType(artifactCoordinates.getType()).build();
    }

    public static BundleDescriptor toBundleDescriptor(Dependency dependency) {
        return new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setBaseVersion(dependency.getVersion()).setClassifier(dependency.getClassifier()).setType(dependency.getType()).build();
    }

    public static List<Artifact> toApplicationModelArtifacts(List<BundleDependency> appDependencies) {
        List<Artifact> dependencies = ArtifactUtils.toArtifacts(appDependencies);
        dependencies.forEach(ArtifactUtils::updateScopeIfDomain);
        return dependencies;
    }

    public static void updateScopeIfDomain(Artifact artifact) {
        String classifier = artifact.getArtifactCoordinates().getClassifier();
        if (StringUtils.equals((CharSequence)classifier, (CharSequence)Classifier.MULE_DOMAIN.toString())) {
            artifact.getArtifactCoordinates().setScope(PROVIDED);
            artifact.setUri(EMPTY_RESOURCE);
        }
    }

    public static ArtifactCoordinates getApplicationArtifactCoordinates(File pomFile) {
        ArtifactCoordinates appCoordinates = ArtifactUtils.toArtifactCoordinates(ArtifactUtils.getPomProjectBundleDescriptor(pomFile));
        appCoordinates.setType(PACKAGE_TYPE);
        appCoordinates.setClassifier(MavenUtils.getPomModelFromFile((File)pomFile).getPackaging());
        return appCoordinates;
    }

    public static BundleDescriptor getPomProjectBundleDescriptor(File pomFile) {
        Model pomModel = MavenUtils.getPomModelFromFile((File)pomFile);
        return ArtifactUtils.getBundleDescriptor(pomModel);
    }

    public static BundleDescriptor getBundleDescriptor(Model pomModel) {
        String version = StringUtils.isNotBlank((CharSequence)pomModel.getVersion()) ? pomModel.getVersion() : pomModel.getParent().getVersion();
        return new BundleDescriptor.Builder().setGroupId(StringUtils.isNotBlank((CharSequence)pomModel.getGroupId()) ? pomModel.getGroupId() : pomModel.getParent().getGroupId()).setArtifactId(pomModel.getArtifactId()).setVersion(version).setBaseVersion(version).setType(POM_TYPE).build();
    }
}

