/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;

public abstract class ClassloaderModelResolver {
    protected final AetherMavenClient muleMavenPluginClient;
    private final String classifier;
    protected Map<BundleDependency, List<BundleDependency>> dependenciesMap;

    public ClassloaderModelResolver(AetherMavenClient muleMavenPluginClient, String classifier) {
        this.muleMavenPluginClient = muleMavenPluginClient;
        this.classifier = classifier;
        this.dependenciesMap = new HashMap<BundleDependency, List<BundleDependency>>();
    }

    public final Collection<ClassLoaderModel> resolve(List<BundleDependency> appDependencies) {
        ArrayList<ClassLoaderModel> classloaderModels = new ArrayList<ClassLoaderModel>();
        List<BundleDependency> dependencies = appDependencies.stream().filter(dep -> dep.getDescriptor().getClassifier().isPresent()).filter(dep -> ((String)dep.getDescriptor().getClassifier().get()).equals(this.classifier)).collect(Collectors.toList());
        this.dependenciesMap = this.resolveDependencies(dependencies);
        for (Map.Entry<BundleDependency, List<BundleDependency>> dependencyListEntry : this.dependenciesMap.entrySet()) {
            ClassLoaderModel dependencyClassloaderModel = new ClassLoaderModel("1.1.0", ArtifactUtils.toArtifactCoordinates(dependencyListEntry.getKey().getDescriptor()));
            List<BundleDependency> dependencyDependencies = this.resolveConflicts(dependencyListEntry.getValue(), dependencies);
            dependencyClassloaderModel.setDependencies(ArtifactUtils.toArtifacts(dependencyDependencies));
            classloaderModels.add(dependencyClassloaderModel);
        }
        return classloaderModels;
    }

    protected abstract List<BundleDependency> resolveConflicts(List<BundleDependency> var1, List<BundleDependency> var2);

    public abstract Map<BundleDependency, List<BundleDependency>> resolveDependencies(List<BundleDependency> var1);

    public List<Artifact> getDependencies() {
        return ArtifactUtils.toArtifacts(this.dependenciesMap.keySet());
    }
}

