/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.project;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.validation.VersionUtils;

public abstract class AbstractProjectValidator {
    public static final String DEPLOY_GOAL = "deploy";
    public static final String VALIDATE_GOAL = "validate";
    protected final boolean strictCheck;
    protected final ProjectInformation projectInformation;

    public AbstractProjectValidator(ProjectInformation projectInformation, boolean strictCheck) {
        this.projectInformation = projectInformation;
        this.strictCheck = strictCheck;
        Preconditions.checkState((projectInformation.getPackaging() != null ? 1 : 0) != 0, (Object)"Packaging type should not be null");
    }

    protected abstract void additionalValidation() throws ValidationException;

    protected abstract void isDeploymentValid() throws ValidationException;

    public Boolean isProjectValid(String goal) throws ValidationException {
        if (StringUtils.equals((CharSequence)VALIDATE_GOAL, (CharSequence)goal)) {
            AbstractProjectValidator.isProjectVersionValid(this.projectInformation.getVersion());
            AbstractProjectValidator.isPackagingTypeValid(this.projectInformation.getPackaging());
            this.additionalValidation();
            if (this.strictCheck) {
                this.isDeploymentValid();
            }
        }
        if (StringUtils.equals((CharSequence)DEPLOY_GOAL, (CharSequence)goal)) {
            this.isDeploymentValid();
        }
        return true;
    }

    private static void isProjectVersionValid(String version) throws ValidationException {
        if (!VersionUtils.isVersionValid(version).booleanValue()) {
            throw new ValidationException("Version " + version + " does not comply with semantic versioning specification");
        }
    }

    public static Boolean isPackagingTypeValid(String packagingType) throws ValidationException {
        try {
            PackagingType.fromString(packagingType);
        }
        catch (IllegalArgumentException e) {
            List packagingTypeNames = Arrays.stream(PackagingType.values()).map(PackagingType::toString).collect(Collectors.toList());
            throw new ValidationException(packagingType == null ? e.getMessage() : "Unknown packaging type " + packagingType + ". Please specify a valid mule packaging type: " + String.join((CharSequence)", ", packagingTypeNames));
        }
        return true;
    }

    public static Boolean isClassifierValid(String classifier) throws ValidationException {
        Set<String> allPossibleClassifiers = AbstractProjectValidator.generateAllValidClassifiers();
        if (classifier == null || !allPossibleClassifiers.contains(classifier)) {
            List classifierNames = allPossibleClassifiers.stream().collect(Collectors.toList());
            throw new ValidationException("Unknown classifier type " + classifier + ". Please specify a valid mule classifier type: " + String.join((CharSequence)", ", classifierNames));
        }
        return true;
    }

    private static Set<String> generateAllValidClassifiers() {
        Set classifierPrefixes = Arrays.stream(Classifier.values()).filter(c -> !c.equals((Object)Classifier.LIGHT_PACKAGE)).filter(c -> !c.equals((Object)Classifier.TEST_JAR)).map(Classifier::toString).collect(Collectors.toSet());
        HashSet<String> allPossibleClassifiers = new HashSet<String>(classifierPrefixes);
        for (String prefix : classifierPrefixes) {
            allPossibleClassifiers.add(prefix + "-" + Classifier.LIGHT_PACKAGE.toString());
        }
        for (String prefix : new ArrayList(allPossibleClassifiers)) {
            allPossibleClassifiers.add(prefix + "-" + Classifier.TEST_JAR.toString());
        }
        return allPossibleClassifiers;
    }
}

