/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.AbstractProjectValidator;
import org.mule.tools.model.Deployment;

public class MuleArtifactJsonValidator {
    public static void validate(Path projectBaseDir, Deployment deploymentConfiguration) throws ValidationException {
        MuleArtifactJsonValidator.isMuleArtifactJsonPresent(projectBaseDir);
        MuleArtifactJsonValidator.isMuleArtifactJsonValid(projectBaseDir, deploymentConfiguration);
    }

    public static void isMuleArtifactJsonPresent(Path projectBaseDir) throws ValidationException {
        String errorMessage = "Invalid Mule project. Missing %s file, it must be present in the root of application";
        if (!projectBaseDir.resolve("mule-artifact.json").toFile().exists()) {
            throw new ValidationException(String.format(errorMessage, "mule-artifact.json"));
        }
    }

    public static void isMuleArtifactJsonValid(Path projectBaseDir, Deployment deploymentConfiguration) throws ValidationException {
        MuleApplicationModel muleArtifact;
        File muleArtifactJsonFile = projectBaseDir.resolve("mule-artifact.json").toFile();
        try {
            muleArtifact = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleArtifactJsonFile, (String)null));
            if (muleArtifact == null) {
                throw new ValidationException("The mule-artifact.json file is empty");
            }
        }
        catch (JsonSyntaxException | IOException e) {
            throw new ValidationException(e);
        }
        MuleArtifactJsonValidator.validateMuleArtifactMandatoryFields(muleArtifact, deploymentConfiguration);
    }

    protected static void validateMuleArtifactMandatoryFields(MuleApplicationModel muleArtifact, Deployment deploymentConfiguration) throws ValidationException {
        ArrayList<String> missingFields = new ArrayList<String>();
        MuleArtifactJsonValidator.checkName(muleArtifact, missingFields);
        MuleArtifactJsonValidator.checkMinMuleVersionValue(muleArtifact, missingFields, deploymentConfiguration);
        MuleArtifactJsonValidator.checkClassLoaderModelDescriptor(muleArtifact, missingFields);
        MuleArtifactJsonValidator.checkRequiredProduct(muleArtifact, missingFields);
        if (!missingFields.isEmpty()) {
            String message = "The following mandatory fields in the mule-artifact.json are missing or invalid: " + missingFields;
            if (missingFields.contains("requiredProduct")) {
                message = message + ". requiredProduct valid values are: MULE, MULE_EE";
            }
            throw new ValidationException(message);
        }
    }

    private static void checkRequiredProduct(MuleApplicationModel muleArtifact, List<String> missingFields) {
        Product requiredProduct = muleArtifact.getRequiredProduct();
        if (requiredProduct == null) {
            missingFields.add("requiredProduct");
        }
    }

    protected static void checkName(MuleApplicationModel muleArtifact, List<String> missingFields) {
        String nameValue = muleArtifact.getName();
        if (StringUtils.isBlank((CharSequence)nameValue)) {
            missingFields.add("name");
        }
    }

    protected static void checkMinMuleVersionValue(MuleApplicationModel muleArtifact, List<String> missingFields, Deployment deploymentConfiguration) throws ValidationException {
        String minMuleVersionValue = muleArtifact.getMinMuleVersion();
        if (StringUtils.isBlank((CharSequence)minMuleVersionValue)) {
            missingFields.add("minMuleVersion");
        } else if (deploymentConfiguration != null && deploymentConfiguration.getMuleVersion().isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)deploymentConfiguration.getMuleVersion().get()))) {
            MuleArtifactJsonValidator.areVersionCompatible((String)deploymentConfiguration.getMuleVersion().get(), minMuleVersionValue);
        }
    }

    private static void areVersionCompatible(String muleVersion, String minMuleVersion) throws ValidationException {
        AbstractProjectValidator.isProjectVersionValid(minMuleVersion);
        AbstractProjectValidator.isProjectVersionValid(muleVersion);
        String minMuleVersionBaseValue = MuleArtifactJsonValidator.getBaseVersion(minMuleVersion);
        String muleVersionBaseValue = MuleArtifactJsonValidator.getBaseVersion(muleVersion);
        if (!MuleArtifactJsonValidator.isVersionBiggerOrEqual(muleVersionBaseValue, minMuleVersionBaseValue)) {
            throw new ValidationException("Mule version that is set in the deployment configuration is not compatible with the minMuleVersion in mule-artifact.json. deploymentConfiguration.muleVersion: " + muleVersion + ", minMuleVersion: " + minMuleVersion);
        }
    }

    private static boolean isVersionBiggerOrEqual(String version1, String version2) {
        List version1Split = Arrays.stream(version1.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
        List version2Split = Arrays.stream(version2.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
        int major1 = (Integer)version1Split.get(0);
        int minor1 = (Integer)version1Split.get(1);
        int patch1 = (Integer)version1Split.get(2);
        int major2 = (Integer)version2Split.get(0);
        int minor2 = (Integer)version2Split.get(1);
        int patch2 = (Integer)version2Split.get(2);
        return major1 > major2 || major1 == major2 && (minor1 > minor2 || minor1 == minor2 && patch1 >= patch2);
    }

    private static String getBaseVersion(String version) {
        int separator = AbstractProjectValidator.getSeparatorIndex(version);
        return separator == -1 ? version : version.substring(0, separator);
    }

    protected static void checkClassLoaderModelDescriptor(MuleApplicationModel muleArtifact, List<String> missingFields) {
        MuleArtifactLoaderDescriptor classLoaderModelDescriptor = muleArtifact.getClassLoaderModelLoaderDescriptor();
        if (classLoaderModelDescriptor == null) {
            missingFields.add("classLoaderModelLoaderDescriptor");
        }
        if (classLoaderModelDescriptor == null || StringUtils.isBlank((CharSequence)classLoaderModelDescriptor.getId())) {
            missingFields.add("classLoaderModelLoaderDescriptor.id");
        }
    }
}

