/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;

public abstract class AbstractProjectValidator {
    protected final ProjectInformation projectInformation;

    public AbstractProjectValidator(ProjectInformation projectInformation) {
        this.projectInformation = projectInformation;
    }

    public Boolean isProjectValid() throws ValidationException {
        Preconditions.checkState((this.projectInformation.getPackaging() != null ? 1 : 0) != 0, (Object)"Packaging type should not be null");
        AbstractProjectValidator.isProjectVersionValid(this.projectInformation.getVersion());
        AbstractProjectValidator.isPackagingTypeValid(this.projectInformation.getPackaging());
        this.additionalValidation();
        return true;
    }

    protected static void isProjectVersionValid(String version) throws ValidationException {
        String suffix;
        String prefixPattern = "^(0|([1-9]\\d*))\\.(0|([1-9]\\d*))\\.(0|([1-9]\\d*))$";
        String suffixPattern = "^([a-zA-Z0-9]|\\.|-)*$";
        int separatorIndex = AbstractProjectValidator.getSeparatorIndex(version);
        String prefix = separatorIndex == -1 ? version : version.substring(0, separatorIndex);
        String string = suffix = separatorIndex == -1 ? "" : version.substring(separatorIndex + 1);
        if (!prefix.matches(prefixPattern) || !suffix.matches(suffixPattern) || separatorIndex == version.length() - 1) {
            throw new ValidationException("Version " + version + " does not comply with semantic versioning specification");
        }
    }

    protected static int getSeparatorIndex(String version) {
        int plusPosition = version.indexOf(43);
        int minusPosition = version.indexOf(45);
        if (plusPosition == -1 || minusPosition == -1) {
            return Math.max(plusPosition, minusPosition);
        }
        return Math.min(plusPosition, minusPosition);
    }

    protected abstract void additionalValidation() throws ValidationException;

    public static Boolean isPackagingTypeValid(String packagingType) throws ValidationException {
        try {
            PackagingType.fromString(packagingType);
        }
        catch (IllegalArgumentException e) {
            List packagingTypeNames = Arrays.stream(PackagingType.values()).map(type -> type.toString()).collect(Collectors.toList());
            throw new ValidationException(packagingType == null ? e.getMessage() : "Unknown packaging type " + packagingType + ". Please specify a valid mule packaging type: " + String.join((CharSequence)", ", packagingTypeNames));
        }
        return true;
    }
}

