/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.util.Project;

public class ProjectInformation {
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private Path projectBaseFolder;
    private Path buildDirectory;
    private boolean isTestProject;
    private Project project;

    private ProjectInformation(String groupId, String artifactId, String version, String packaging, Path projectBaseFolder, Path buildDirectory, boolean isTestProject, Project project) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.projectBaseFolder = projectBaseFolder;
        this.buildDirectory = buildDirectory;
        this.isTestProject = isTestProject;
        this.project = project;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public Path getProjectBaseFolder() {
        return this.projectBaseFolder;
    }

    public Path getBuildDirectory() {
        return this.buildDirectory;
    }

    public boolean isTestProject() {
        return this.isTestProject;
    }

    public Project getProject() {
        return this.project;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String packaging;
        private Path projectBaseFolder;
        private Path buildDirectory;
        private Boolean isTestProject;
        private Project project;

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withPackaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        public Builder withProjectBaseFolder(Path projectBaseFolder) {
            this.projectBaseFolder = projectBaseFolder;
            return this;
        }

        public Builder withBuildDirectory(Path buildDirectory) {
            this.buildDirectory = buildDirectory;
            return this;
        }

        public Builder setTestProject(Boolean isTestProject) {
            this.isTestProject = isTestProject;
            return this;
        }

        public Builder withDependencyProject(Project project) {
            this.project = project;
            return this;
        }

        public ProjectInformation build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupId), (Object)"Group id should not be null nor blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.artifactId), (Object)"Artifact id should not be null nor blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.version), (Object)"Version should not be null nor blank");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.packaging), (Object)"Version should not be null nor blank");
            Preconditions.checkArgument((this.projectBaseFolder != null ? 1 : 0) != 0, (Object)"Project base folder should not be null");
            Preconditions.checkArgument((this.buildDirectory != null ? 1 : 0) != 0, (Object)"Project build directory should not be null");
            Preconditions.checkArgument((this.isTestProject != null ? 1 : 0) != 0, (Object)"Project isTestProject property was not set");
            Preconditions.checkArgument((this.project != null ? 1 : 0) != 0, (Object)"Project should not be null");
            return new ProjectInformation(this.groupId, this.artifactId, this.version, this.packaging, this.projectBaseFolder, this.buildDirectory, this.isTestProject, this.project);
        }
    }
}

