/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.project;

import java.io.File;
import java.nio.file.Path;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.validation.project.AbstractProjectValidator;

public class MuleProjectValidator
extends AbstractProjectValidator {
    public MuleProjectValidator(ProjectInformation projectInformation) {
        super(projectInformation);
    }

    @Override
    protected void additionalValidation() throws ValidationException {
        MuleProjectValidator.isProjectStructureValid(this.projectInformation.getPackaging(), this.projectInformation.getProjectBaseFolder());
    }

    public static void isProjectStructureValid(String packagingType, Path projectBaseDir) throws ValidationException {
        File mainSrcApplication = MuleProjectValidator.mainSrcApplication(packagingType, projectBaseDir);
        if (!mainSrcApplication.exists()) {
            throw new ValidationException("The folder " + mainSrcApplication.getAbsolutePath() + " is mandatory");
        }
        File muleDeployProperties = new File(mainSrcApplication, "mule-deploy.properties");
        if (!muleDeployProperties.exists()) {
            throw new ValidationException("The file " + muleDeployProperties.getAbsolutePath() + " is mandatory");
        }
    }

    private static File mainSrcApplication(String packagingType, Path projectBaseDir) throws ValidationException {
        return PackagingType.fromString(packagingType).getSourceFolderLocation(projectBaseDir).toFile();
    }
}

