/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.sources;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.mule.tools.api.packager.ProjectInformation;

public abstract class ContentGenerator {
    protected final ProjectInformation projectInformation;

    public ContentGenerator(ProjectInformation projectInformation) {
        Preconditions.checkArgument((boolean)projectInformation.getProjectBaseFolder().toFile().exists(), (Object)"Project base folder should exist");
        Preconditions.checkArgument((boolean)projectInformation.getBuildDirectory().toFile().exists(), (Object)"Project build folder should exist");
        this.projectInformation = projectInformation;
    }

    public abstract void createContent() throws IOException;

    public static void checkPathExist(Path path) {
        Preconditions.checkArgument((boolean)path.toFile().exists(), (Object)("The path: " + path.toString() + " should exist"));
    }

    public static void copyFile(Path originPath, Path destinationPath, String destinationFileName) throws IOException {
        ContentGenerator.checkPathExist(originPath);
        ContentGenerator.checkPathExist(destinationPath);
        Files.copy(originPath, destinationPath.resolve(destinationFileName), StandardCopyOption.REPLACE_EXISTING);
    }
}

