/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.packaging;

import java.util.ArrayList;
import java.util.List;
import org.mule.tools.api.packager.packaging.Exclusion;
import org.mule.tools.api.packager.packaging.Inclusion;

public class PackagingOptions {
    private final boolean archiveClasses;
    private final ArrayList<Exclusion> exclusions;
    private final ArrayList<Inclusion> inclusions;
    private final boolean excludeMuleDependencies;
    private final boolean filterAppDirectory;
    private final boolean prependGroupId;

    private PackagingOptions(boolean archiveClasses, ArrayList<Exclusion> exclusions, ArrayList<Inclusion> inclusions, boolean excludeMuleDependencies, boolean filterAppDirectory, boolean prependGroupId) {
        this.archiveClasses = archiveClasses;
        this.exclusions = exclusions;
        this.inclusions = inclusions;
        this.excludeMuleDependencies = excludeMuleDependencies;
        this.filterAppDirectory = filterAppDirectory;
        this.prependGroupId = prependGroupId;
    }

    public boolean isArchiveClasses() {
        return this.archiveClasses;
    }

    public List<Exclusion> getExclusions() {
        return (ArrayList)this.exclusions.clone();
    }

    public List<Inclusion> getInclusions() {
        return (ArrayList)this.inclusions.clone();
    }

    public boolean isExcludeMuleDependencies() {
        return this.excludeMuleDependencies;
    }

    public boolean isPrependGroupId() {
        return this.prependGroupId;
    }

    public boolean isFilterAppDirectory() {
        return this.filterAppDirectory;
    }

    public static class PackagingOptionsBuilder {
        private boolean archiveClasses = false;
        private ArrayList<Exclusion> exclusions = new ArrayList();
        private ArrayList<Inclusion> inclusions = new ArrayList();
        private boolean excludeMuleDependencies = true;
        private boolean filterAppDirectory = false;
        private boolean prependGroupId = false;

        public PackagingOptionsBuilder withArchiveClasses(boolean archiveClasses) {
            this.archiveClasses = archiveClasses;
            return this;
        }

        public PackagingOptionsBuilder withExclusions(ArrayList<Exclusion> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public PackagingOptionsBuilder withInclusions(ArrayList<Inclusion> inclusions) {
            this.inclusions = inclusions;
            return this;
        }

        public PackagingOptionsBuilder withExcludeMuleDependencies(boolean excludeMuleDependencies) {
            this.excludeMuleDependencies = excludeMuleDependencies;
            return this;
        }

        public PackagingOptionsBuilder withFilterAppDirectory(boolean filterAppDirectory) {
            this.filterAppDirectory = filterAppDirectory;
            return this;
        }

        public PackagingOptionsBuilder withPrependGroupId(boolean prependGroupId) {
            this.prependGroupId = prependGroupId;
            return this;
        }

        public PackagingOptions build() {
            return new PackagingOptions(this.archiveClasses, this.exclusions, this.inclusions, this.excludeMuleDependencies, this.filterAppDirectory, this.prependGroupId);
        }
    }
}

