/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.filter;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.tools.api.packager.filter.ArtifactFilter;
import org.mule.tools.api.packager.filter.predicate.AbstractArtifactPrefixPredicate;
import org.mule.tools.api.packager.filter.predicate.CompileOrRuntimeScopePredicate;
import org.mule.tools.api.packager.packaging.Exclusion;
import org.mule.tools.api.packager.packaging.Inclusion;
import org.mule.tools.api.util.Artifact;

public class DependenciesFilter {
    private Set<Artifact> projectArtifacts;
    private List<Exclusion> exclusions;
    private List<Inclusion> inclusions;
    private boolean excludeMuleArtifacts;
    private final HashSet<String> muleGroupIds = Sets.newHashSet((Object[])new String[]{"org.mule", "com.mulesource.muleesb", "com.mulesoft.muleesb"});
    protected ArtifactFilter artifactFilter;

    public DependenciesFilter(Set<Artifact> projectArtifacts, List<? extends Inclusion> inclusions, List<? extends Exclusion> exclusions, boolean excludeMuleArtifacts) {
        this.projectArtifacts = Collections.unmodifiableSet(projectArtifacts);
        this.inclusions = inclusions == null ? new ArrayList() : inclusions;
        this.exclusions = exclusions == null ? new ArrayList() : exclusions;
        this.excludeMuleArtifacts = excludeMuleArtifacts;
        this.artifactFilter = new ArtifactFilter();
    }

    public Set<Artifact> getArtifactsToArchive() {
        Set<Artifact> filteredArtifacts = this.resolveNotCompileNorRuntimeArtifacts(this.projectArtifacts);
        if (this.excludeMuleArtifacts) {
            filteredArtifacts = this.removeDependenciesWithMuleGroupId(filteredArtifacts);
        }
        filteredArtifacts = this.applyExclusions(filteredArtifacts);
        filteredArtifacts = this.applyIncludes(filteredArtifacts);
        return filteredArtifacts;
    }

    protected Set<Artifact> resolveNotCompileNorRuntimeArtifacts(Set<Artifact> projectArtifacts) {
        CompileOrRuntimeScopePredicate predicate = new CompileOrRuntimeScopePredicate();
        return this.artifactFilter.filter(projectArtifacts, new HashSet<Artifact>(), predicate);
    }

    protected Set<Artifact> removeDependenciesWithMuleGroupId(Set<Artifact> filteredArtifacts) {
        AbstractArtifactPrefixPredicate.OnlyDependenciesTrailFilterPredicate predicate = new AbstractArtifactPrefixPredicate.OnlyDependenciesTrailFilterPredicate(this.muleGroupIds);
        return this.artifactFilter.filter(filteredArtifacts, new HashSet<Artifact>(), predicate);
    }

    protected Set<Artifact> applyExclusions(Set<Artifact> filteredArtifacts) {
        AbstractArtifactPrefixPredicate.TrailFilterPredicate predicate = new AbstractArtifactPrefixPredicate.TrailFilterPredicate(this.getAsFilters(this.exclusions));
        return this.artifactFilter.filter(filteredArtifacts, new HashSet<Artifact>(), predicate);
    }

    protected Set<Artifact> applyIncludes(Set<Artifact> filteredArtifacts) {
        AbstractArtifactPrefixPredicate.NotOptionalTrailFilterPredicate predicate = new AbstractArtifactPrefixPredicate.NotOptionalTrailFilterPredicate(this.getAsFilters(this.inclusions));
        return this.artifactFilter.filter(this.projectArtifacts, filteredArtifacts, predicate);
    }

    protected List<String> getAsFilters(List<? extends Exclusion> exclusions) {
        ArrayList<String> filters = new ArrayList<String>();
        for (Exclusion exclusion : exclusions) {
            filters.add(exclusion.asFilter() + ":");
        }
        return filters;
    }
}

