/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.archiver;

import java.io.File;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.mule.tools.api.packager.archiver.AbstractArchiver;
import org.mule.tools.api.packager.structure.FolderNames;

public class MuleArchiver
extends AbstractArchiver {
    private static final String CLASSES_LOCATION = FolderNames.CLASSES.value() + File.separator;
    private static final String API_LOCATION = FolderNames.API.value() + File.separator;
    private static final String LIB_LOCATION = FolderNames.LIB.value() + File.separator;

    public MuleArchiver() {
        this((org.codehaus.plexus.archiver.AbstractArchiver)new ZipArchiver());
    }

    protected MuleArchiver(org.codehaus.plexus.archiver.AbstractArchiver archiver) {
        super(archiver);
    }

    public void addClasses(File resource, String[] includes, String[] excludes) throws ArchiverException {
        this.addResource(CLASSES_LOCATION, resource, includes, excludes);
    }

    public void addApi(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource != null && resource.exists() && resource.list() != null && resource.list().length != 0) {
            this.addResource(API_LOCATION, resource, includes, excludes);
            this.addClasses(resource, includes, excludes);
        }
    }

    public void addWsdl(File resource, String[] includes, String[] excludes) throws ArchiverException {
        if (resource != null && resource.exists() && resource.list() != null && resource.list().length != 0) {
            this.addClasses(resource, includes, excludes);
        }
    }

    public void addLib(File resource, String[] includes, String[] excludes) {
        if (resource != null && resource.exists() && resource.list() != null && resource.list().length != 0) {
            this.addResource(LIB_LOCATION, resource, includes, excludes);
        }
    }

    public void addMappings(File resource, String[] includes, String[] excludes) {
        if (resource != null && resource.exists() && resource.list() != null && resource.list().length != 0) {
            this.addClasses(resource, includes, excludes);
        }
    }
}

