/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.config.proxy;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

public class ProxyConfiguration {
    public static final String HTTP_PROXY_URI = "http.proxyUri";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTP_NO_PROXY = "http.nonProxyHosts";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String PROTOCOL_HTTP = "http";
    public static final String MAVEN_PROXY_HOST = "proxyHost";
    public static final String MAVEN_PROXY_PORT = "proxyPort";
    protected final Log log;
    protected Settings settings;

    public ProxyConfiguration(Log log, Settings settings) {
        this.log = log;
        this.settings = settings;
    }

    public void handleProxySettings() throws Exception {
        Proxy proxy = this.getProxy(this.settings);
        if (ProxyConfiguration.isProxyValid(proxy)) {
            this.setupProxyProperties(proxy);
            this.setupNonProxyHostsProperties(proxy);
            this.setupProxyCredentials(proxy);
        }
    }

    private void setupProxyCredentials(final Proxy proxy) {
        if (StringUtils.isNotBlank((CharSequence)proxy.getUsername())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxy.getUsername(), proxy.getPassword().toCharArray());
                }
            });
            this.log.info((CharSequence)String.format("Proxy settings authentication detected. %s:*****", proxy.getUsername()));
        }
    }

    private void setupNonProxyHostsProperties(Proxy proxy) {
        ProxyConfiguration.setPropertyIfNotBlank(HTTP_NO_PROXY, proxy.getNonProxyHosts());
    }

    private void setupProxyProperties(Proxy proxy) {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(proxy.getProtocol());
        uriBuilder.setHost(proxy.getHost());
        uriBuilder.setPort(proxy.getPort());
        System.setProperty(HTTP_PROXY_URI, uriBuilder.toString());
        System.setProperty(HTTP_PROXY_HOST, proxy.getHost());
        System.setProperty(MAVEN_PROXY_HOST, proxy.getHost());
        System.setProperty(HTTP_PROXY_PORT, String.valueOf(proxy.getPort()));
        System.setProperty(MAVEN_PROXY_PORT, String.valueOf(proxy.getPort()));
        ProxyConfiguration.setPropertyIfNotBlank(HTTP_PROXY_USER, proxy.getUsername());
        ProxyConfiguration.setPropertyIfNotBlank(HTTP_PROXY_PASSWORD, proxy.getPassword());
    }

    private static boolean isProxyValid(Proxy proxy) {
        return proxy != null && StringUtils.isNotBlank((CharSequence)proxy.getHost()) && proxy.getPort() > 0;
    }

    private Proxy getProxy(Settings settings) throws Exception {
        if (!StringUtils.isBlank((CharSequence)System.getProperty(HTTP_PROXY_HOST))) {
            return this.buildProxyFromProperties(System.getProperty(HTTP_PROXY_HOST), System.getProperty(HTTP_PROXY_PORT), System.getProperty(HTTP_PROXY_USER), System.getProperty(HTTP_PROXY_PASSWORD));
        }
        if (!StringUtils.isBlank((CharSequence)System.getProperty(HTTPS_PROXY_HOST))) {
            return this.buildProxyFromProperties(System.getProperty(HTTPS_PROXY_HOST), System.getProperty(HTTPS_PROXY_PORT), System.getProperty(HTTPS_PROXY_USER), System.getProperty(HTTPS_PROXY_PASSWORD));
        }
        return (Proxy)IterableUtils.find((Iterable)settings.getProxies(), item -> item.isActive() && (PROTOCOL_HTTP.equalsIgnoreCase(item.getProtocol()) || StringUtils.isBlank((CharSequence)item.getProtocol())));
    }

    private Proxy buildProxyFromProperties(String host, String port, String username, String password) throws Exception {
        Proxy proxy = new Proxy();
        proxy.setHost(host);
        proxy.setUsername(username);
        if (!StringUtils.isBlank((CharSequence)password)) {
            proxy.setPassword(password);
        } else {
            this.log.warn((CharSequence)"Proxy password was not defined.");
        }
        if (!StringUtils.isBlank((CharSequence)port)) {
            proxy.setPort(Integer.parseInt(port));
        } else {
            this.log.warn((CharSequence)"Proxy port was not defined.");
        }
        return proxy;
    }

    public static boolean isAbleToSetupProxy(Settings settings) {
        return !StringUtils.isBlank((CharSequence)System.getProperty(HTTP_PROXY_HOST)) || !StringUtils.isBlank((CharSequence)System.getProperty(HTTPS_PROXY_HOST)) || settings != null && CollectionUtils.isNotEmpty((Collection)settings.getProxies());
    }

    private static void setPropertyIfNotBlank(String property, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            System.setProperty(property, value);
        }
    }
}

