/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.builder.PackageBuilder;
import org.mule.tools.api.packager.builder.PackageBuilderFactory;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.packaging.PackagingOptions;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractMuleMojo {
    private static final String JAR_EXTENSION = "jar";
    private static final String ZIP_EXTENSION = "zip";
    @Component
    protected MavenProjectHelper helper;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${onlyMuleSources}")
    protected boolean onlyMuleSources = false;
    @Parameter(defaultValue="${attachMuleSources}")
    protected boolean attachMuleSources = false;
    protected PackagingOptions options;

    @Override
    public void doExecute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Packaging...");
        String targetFolder = this.project.getBuild().getDirectory();
        File destinationFile = this.getDestinationFile(targetFolder);
        try {
            this.getPackageBuilder().createPackage(Paths.get(targetFolder, new String[0]), destinationFile.toPath());
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)e);
        }
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", this.getType(), this.getPackagingType().resolveClassifier(this.classifier, this.lightweightPackage, this.testJar), this.artifactHandlerManager.getArtifactHandler(this.getType()));
        artifact.setFile(destinationFile);
        this.project.setArtifact((Artifact)artifact);
        if (this.project.getPackaging().equals(Classifier.MULE_POLICY.toString())) {
            File policyYaml = new File(this.projectBaseFolder, String.format("%s.yaml", this.project.getArtifactId()));
            this.helper.attachArtifact(this.project, "yaml", "policy-definition", policyYaml);
        }
    }

    protected File getDestinationFile(String targetFolder) throws MojoExecutionException {
        Preconditions.checkArgument((targetFolder != null ? 1 : 0) != 0, (Object)"The target folder must not be null");
        Path destinationPath = Paths.get(targetFolder, this.getFileName());
        try {
            Files.deleteIfExists(destinationPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Exception deleting the file [%s]", destinationPath), (Exception)e);
        }
        return destinationPath.toFile();
    }

    protected String getFileName() {
        return this.project.getBuild().getFinalName() + "-" + this.getClassifier() + "." + this.getType();
    }

    protected PackageBuilder getPackageBuilder() {
        this.options = this.buildPackagingOptions();
        return PackageBuilderFactory.create((PackagingType)this.getPackagingType(), (PackagingOptions)this.options);
    }

    protected PackagingOptions buildPackagingOptions() {
        boolean isMuleApplicationTemplate = Classifier.MULE_APPLICATION_TEMPLATE.equals(this.classifier);
        boolean isMuleApplicationExample = Classifier.MULE_APPLICATION_EXAMPLE.equals(this.classifier);
        boolean isMuleReusableApp = Classifier.MULE_PLUGIN.equals(this.classifier);
        return new PackagingOptions(isMuleApplicationTemplate || this.onlyMuleSources, isMuleReusableApp || this.lightweightPackage, isMuleApplicationExample || this.attachMuleSources, this.testJar, this.useLocalRepository);
    }

    private String getType() {
        return this.getPackagingType().equals((Object)PackagingType.MULE_DOMAIN_BUNDLE) ? ZIP_EXTENSION : JAR_EXTENSION;
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PACKAGE_PREVIOUS_RUN_PLACEHOLDER";
    }
}

