/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.packager.structure.FolderNames;
import org.mule.tools.api.util.MavenComponents;
import org.mule.tools.api.util.SourcesProcessor;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="process-sources", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ProcessSourcesMojo
extends AbstractMuleMojo {
    @Deprecated
    @Parameter(defaultValue="${skipPluginCompatibilityValidation}")
    protected boolean skipPluginCompatibilityValidation = false;
    @Parameter(defaultValue="${prettyPrinting}")
    protected boolean prettyPrinting = false;

    @Override
    public void doExecute() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Processing sources...");
        if (this.skipPluginCompatibilityValidation) {
            this.getLog().warn((CharSequence)"Ignoring skipPluginCompatibilityValidation property as it is deprecated. Compatibility between mule-plugin versions is always done.");
        }
        MavenComponents mavenComponents = new MavenComponents().withLog(this.getLog()).withProject(this.project).withOutputDirectory(this.outputDirectory).withSession(this.session).withSharedLibraries(this.sharedLibraries).withProjectBuilder(this.projectBuilder).withRepositorySystem(this.repositorySystem).withLocalRepository(this.localRepository).withRemoteArtifactRepositories(this.remoteArtifactRepositories).withClassifier(this.classifier).withAdditionalPluginDependencies(this.additionalPluginDependencies).withProjectBaseFolder(this.projectBaseFolder);
        SourcesProcessor sourcesProcessor = new SourcesProcessor(mavenComponents);
        try {
            sourcesProcessor.process(this.prettyPrinting, this.lightweightPackage, this.useLocalRepository, this.testJar, this.outputDirectory, this.getProjectInformation().getBuildDirectory().resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).toFile(), Optional.empty());
        }
        catch (Exception e) {
            String message = String.format("There was an exception while creating the repository of [%s]", this.project.toString());
            throw new MojoFailureException(message, (Throwable)e);
        }
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PROCESS_SOURCES_PREVIOUS_RUN_PLACEHOLDER";
    }
}

