/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.utils;

import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import org.apache.maven.project.MavenProject;
import org.mule.tools.api.packager.structure.FolderNames;

public class ProjectDirectoryUpdater {
    private final MavenProject project;

    public ProjectDirectoryUpdater(MavenProject project) {
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"The project must not be null");
        this.project = project;
    }

    public void updateBuildDirectory(String buildDirectory) {
        Preconditions.checkArgument((buildDirectory != null ? 1 : 0) != 0, (Object)"The project build directory must not be null");
        this.project.getBuild().setDirectory(buildDirectory);
        this.updateBuildOutputDirectory(buildDirectory);
        this.updateBuildTestOputputDirectory(buildDirectory);
        this.updateReportingOutputDirectory(buildDirectory);
    }

    public void updateBuildOutputDirectory(String buildDirectory) {
        Preconditions.checkArgument((buildDirectory != null ? 1 : 0) != 0, (Object)"The project build directory must not be null");
        this.project.getModel().getBuild().setOutputDirectory(Paths.get(buildDirectory, FolderNames.CLASSES.value()).toString());
    }

    public void updateBuildTestOputputDirectory(String buildDirectory) {
        Preconditions.checkArgument((buildDirectory != null ? 1 : 0) != 0, (Object)"The project build directory must not be null");
        this.project.getModel().getBuild().setTestOutputDirectory(Paths.get(buildDirectory, FolderNames.TEST_CLASSES.value()).toString());
    }

    public void updateReportingOutputDirectory(String buildDirectory) {
        Preconditions.checkArgument((buildDirectory != null ? 1 : 0) != 0, (Object)"The project build directory must not be null");
        this.project.getModel().getReporting().setOutputDirectory(Paths.get(buildDirectory, FolderNames.SITE.value()).toString());
    }
}

