/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.validation.AllowedDependencyValidator;
import org.mule.tools.api.validation.VersionUtils;
import org.mule.tools.api.validation.project.AbstractProjectValidator;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateMojo
extends AbstractMuleMojo {
    private static final String MIN_MAVEN_VERSION = "3.3.3";

    @Override
    public void doExecute() throws MojoExecutionException {
        if (!this.skipValidation) {
            try {
                this.validateMavenEnvironment();
                this.getLog().debug((CharSequence)"Validating Mule application...");
                AbstractProjectValidator.isPackagingTypeValid((String)this.project.getPackaging());
                this.validateNotAllowedDependencies();
            }
            catch (ValidationException e) {
                throw new MojoExecutionException("Validation exception", (Exception)((Object)e));
            }
        } else {
            this.getLog().debug((CharSequence)"Skipping Validation for Mule application");
        }
    }

    protected void validateMavenEnvironment() throws ValidationException {
        this.getLog().debug((CharSequence)"Validating Maven environment...");
        String mavenVersion = (String)this.session.getRequest().getSystemProperties().get("maven.version");
        if (!VersionUtils.isVersionGreaterOrEquals((String)mavenVersion, (String)MIN_MAVEN_VERSION).booleanValue()) {
            throw new ValidationException("Your Maven installation version is: " + mavenVersion + " We require at least:" + MIN_MAVEN_VERSION);
        }
    }

    protected void validateNotAllowedDependencies() throws ValidationException {
        if (!this.project.getPackaging().equals(PackagingType.MULE_DOMAIN_BUNDLE.toString())) {
            List dependencies = this.project.getDependencies().stream().map(d -> this.buildArtifactCoordinates((Dependency)d)).collect(Collectors.toList());
            AllowedDependencyValidator.areDependenciesAllowed(dependencies);
        }
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_VALIDATE_PREVIOUS_RUN_PLACEHOLDER";
    }

    protected ArtifactCoordinates buildArtifactCoordinates(Dependency dependency) {
        ArtifactCoordinates artifactCoordinates = new ArtifactCoordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        artifactCoordinates.setType(dependency.getType());
        artifactCoordinates.setScope(dependency.getScope());
        artifactCoordinates.setClassifier(dependency.getClassifier());
        return artifactCoordinates;
    }
}

