/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.util.Project;
import org.mule.tools.maven.utils.ArtifactUtils;

public class DependencyProject
implements Project {
    private MavenProject mavenProject;

    public DependencyProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public List<ArtifactCoordinates> getDependencies() {
        return this.mavenProject.getDependencies().stream().map(ArtifactUtils::toArtifactCoordinates).collect(Collectors.toList());
    }

    public List<BundleDependency> getBundleDependencies() {
        return this.mavenProject.getArtifacts().stream().map(this::toBundleDependency).collect(Collectors.toList());
    }

    private BundleDependency toBundleDependency(Artifact artifact) {
        BundleDescriptor.Builder descriptorBuilder = new BundleDescriptor.Builder();
        BundleDescriptor descriptor = descriptorBuilder.setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setClassifier(artifact.getClassifier()).setType(artifact.getType()).build();
        BundleDependency.Builder dependencyBuilder = new BundleDependency.Builder();
        return dependencyBuilder.setBundleUri(artifact.getFile().toURI()).setDescriptor(descriptor).setScope(BundleScope.valueOf((String)artifact.getScope().toUpperCase())).build();
    }
}

